/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.service.impl;

import com.hand.hap.flexfield.dto.FlexModel;
import com.hand.hap.flexfield.dto.FlexModelColumn;
import com.hand.hap.flexfield.dto.FlexRuleSet;
import com.hand.hap.flexfield.mapper.FlexModelColumnMapper;
import com.hand.hap.flexfield.mapper.FlexModelMapper;
import com.hand.hap.flexfield.mapper.FlexRuleSetMapper;
import com.hand.hap.flexfield.service.IFlexModelService;
import com.hand.hap.flexfield.service.IFlexRuleSetService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlexModelServiceImpl
extends BaseServiceImpl<FlexModel>
implements IFlexModelService {
    @Autowired
    private FlexModelColumnMapper modelColumnMapper;
    @Autowired
    private FlexModelMapper modelMapper;
    @Autowired
    private IFlexRuleSetService setService;
    @Autowired
    private FlexRuleSetMapper flexRuleSetMapper;

    @Transactional(rollbackFor={Exception.class})
    public void deleteFlexModel(List<FlexModel> models) {
        for (FlexModel flexModel : models) {
            int updateCount = this.modelMapper.deleteByPrimaryKey((Object)flexModel);
            this.checkOvn(updateCount, (Object)flexModel);
            this.modelColumnMapper.delete((Object)new FlexModelColumn(flexModel.getModelId()));
        }
        models.stream().forEach(v -> {
            FlexRuleSet flexModelSet = new FlexRuleSet();
            flexModelSet.setModelId(v.getModelId());
            this.setService.deleteRuleSet(this.flexRuleSetMapper.select((Object)flexModelSet));
        });
    }
}

