/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.flexfield.service.IFlexRuleService;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.ResponseData;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FlexFieldQueryAspect {
    @Autowired
    IFlexRuleService iFlexRuleService;

    @Pointcut(value="execution(* *..*Controller.*(..))")
    public void pointCut() {
    }

    @AfterReturning(value="pointCut()", returning="responseData")
    public void FlexLovFieldAspect(JoinPoint joinpoint, Object responseData) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IOException {
        HttpServletRequest httpServletRequest = null;
        Object dto = null;
        for (int i = 0; i < joinpoint.getArgs().length; ++i) {
            if (joinpoint.getArgs()[i] instanceof HttpServletRequest) {
                httpServletRequest = (HttpServletRequest)joinpoint.getArgs()[i];
                continue;
            }
            if (!(joinpoint.getArgs()[i] instanceof BaseDTO)) continue;
            dto = joinpoint.getArgs()[i];
        }
        if (null == httpServletRequest || null == dto) {
            return;
        }
        if (httpServletRequest.getParameterMap().containsKey("_FLEX_RULE_SET_CODE")) {
            IRequest iRequest = RequestHelper.createServiceRequest((HttpServletRequest)httpServletRequest);
            String flexRuleCode = ((String[])httpServletRequest.getParameterMap().get("_FLEX_RULE_SET_CODE"))[0];
            if (responseData instanceof ResponseData) {
                ResponseData responseData1 = (ResponseData)responseData;
                if (null != responseData1.getRows() && responseData1.getRows().size() != 0) {
                    for (Object o : responseData1.getRows()) {
                        this.iFlexRuleService.matchingLovField(flexRuleCode, BeanUtils.describe((Object)dto).entrySet(), o, iRequest);
                    }
                }
            } else {
                this.iFlexRuleService.matchingLovField(flexRuleCode, BeanUtils.describe((Object)dto).entrySet(), responseData, iRequest);
            }
        }
    }
}

