/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.extensible.base;

import com.hand.hap.extensible.base.DtoExtension;
import com.hand.hap.extensible.base.ExtendedField;
import com.hand.hap.extensible.base.ExtensionConfigParser;
import com.hand.hap.system.dto.BaseDTO;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.javassist.CannotCompileException;
import org.apache.ibatis.javassist.ClassClassPath;
import org.apache.ibatis.javassist.ClassPath;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.CtMethod;
import org.apache.ibatis.javassist.NotFoundException;
import org.apache.ibatis.javassist.bytecode.AnnotationsAttribute;
import org.apache.ibatis.javassist.bytecode.AttributeInfo;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DtoExtensionManager {
    private static Map<String, List<DtoExtension>> dtoExtensionMap = new HashMap();
    private static Logger logger;

    public static void scanExtendConfig() throws Exception {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        Resource[] configs = patternResolver.getResources("classpath*:/extension/**/*.extend.xml");
        ClassPool classPool = ClassPool.getDefault();
        for (Resource resource : configs) {
            logger.debug("find dto extend config:{}", (Object)resource);
            List dtoExtensionList = DtoExtensionManager.parseConfig((InputStream)resource.getInputStream());
            for (DtoExtension dtoExtension : dtoExtensionList) {
                ArrayList<DtoExtension> extensionList2 = (ArrayList<DtoExtension>)dtoExtensionMap.get(dtoExtension.getTarget());
                if (extensionList2 == null) {
                    extensionList2 = new ArrayList<DtoExtension>();
                    dtoExtensionMap.put(dtoExtension.getTarget(), extensionList2);
                }
                extensionList2.add(dtoExtension);
            }
        }
        HashMap<String, CtClass> ctClassMap = new HashMap<String, CtClass>();
        dtoExtensionMap.forEach((dto, extensionList) -> {
            logger.debug("process dto extending : {} , {} extensions", dto, (Object)extensionList.size());
            try {
                CtClass ctClass = (CtClass)ctClassMap.get(dto);
                if (ctClass == null) {
                    ctClass = classPool.getCtClass(dto);
                    ctClassMap.put((String)dto, ctClass);
                }
                ConstPool constPool = ctClass.getClassFile2().getConstPool();
                HashSet<String> existsMethods = new HashSet<String>();
                for (DtoExtension dtoExtension : extensionList) {
                    logger.debug("+ interface {} -> {}", (Object)dtoExtension.getExtension(), dto);
                    CtClass ctClass2 = classPool.getCtClass(dtoExtension.getExtension());
                    CtMethod[] newMethod = ctClass2.getMethods();
                    for (CtMethod nm : newMethod) {
                        if (nm.getDeclaringClass() != ctClass2) continue;
                        logger.debug("+    method {} -> {}", (Object)nm.getName(), dto);
                        CtMethod methodCopy = new CtMethod(nm.getReturnType(), nm.getName(), nm.getParameterTypes(), ctClass);
                        List attributes = nm.getMethodInfo().getAttributes();
                        for (AttributeInfo ai : attributes) {
                            if (!(ai instanceof AnnotationsAttribute)) continue;
                            methodCopy.getMethodInfo().addAttribute(ai);
                        }
                        String name = methodCopy.getName();
                        String attributeName = StringUtils.uncapitalize((String)name.substring(3));
                        existsMethods.add(methodCopy.getName());
                        if (name.startsWith("set") && methodCopy.getParameterTypes().length == 1) {
                            methodCopy.setBody("innerSet(\"" + attributeName + "\",$1);");
                        } else if (name.startsWith("get") && methodCopy.getParameterTypes().length == 0) {
                            methodCopy.setBody("return (" + methodCopy.getReturnType().getName() + ")innerGet(\"" + attributeName + "\");");
                        }
                        methodCopy.setModifiers(1);
                        ctClass.addMethod(methodCopy);
                    }
                    for (ExtendedField extendedField : dtoExtension.getExtendedFields()) {
                        DtoExtensionManager.addSetterGetter((CtClass)ctClass, (ExtendedField)extendedField, existsMethods);
                    }
                    ctClass.addInterface(ctClass2);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        ctClassMap.forEach((k, v) -> {
            try {
                logger.debug("create class:" + k);
                v.toClass();
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
        });
    }

    private static void addSetterGetter(CtClass ctClass, ExtendedField extendedField, Set<String> existsMethods) throws NotFoundException, CannotCompileException {
        String setterName;
        CtClass type = ClassPool.getDefault().get(extendedField.getJavaType());
        String getterName = "get" + StringUtils.capitalize((String)extendedField.getFieldName());
        if (!existsMethods.contains(getterName)) {
            logger.debug("+    getter for {} -> {}", (Object)extendedField.getFieldName(), (Object)ctClass.getName());
            CtMethod getter = new CtMethod(type, getterName, new CtClass[0], ctClass);
            getter.setBody("return (" + extendedField.getJavaType() + ")innerGet(\"" + extendedField.getFieldName() + "\");");
            ctClass.addMethod(getter);
            existsMethods.add(getterName);
        }
        if (!existsMethods.contains(setterName = "set" + StringUtils.capitalize((String)extendedField.getFieldName()))) {
            logger.debug("+    setter for {} -> {}", (Object)extendedField.getFieldName(), (Object)ctClass.getName());
            CtMethod setter = new CtMethod(CtClass.voidType, setterName, new CtClass[]{type}, ctClass);
            setter.setBody("innerSet(\"" + extendedField.getFieldName() + "\",$1);");
            ctClass.addMethod(setter);
            existsMethods.add(setterName);
        }
    }

    private static List<DtoExtension> parseConfig(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        try (InputStream ignore = inputStream;){
            List list = new ExtensionConfigParser().parse(inputStream);
            return list;
        }
    }

    public static List<DtoExtension> getExtensionConfig(Class clazz) {
        return (List)dtoExtensionMap.get(clazz.getName());
    }

    static {
        ClassPool.getDefault().insertClassPath((ClassPath)new ClassClassPath(BaseDTO.class));
        logger = LoggerFactory.getLogger(DtoExtensionManager.class);
    }
}

