/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.service.impl.ExcelSheetStrategy;
import com.hand.hap.excel.util.TableUtils;
import com.hand.hap.mybatis.common.BaseMapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportStrategy
extends ExcelSheetStrategy {
    protected BaseMapper baseMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ImportStrategy(Connection connection, String tableName) throws SQLException, ClassNotFoundException {
        super(connection, tableName);
        this.baseMapper = TableUtils.getBaseMapperByType((Class)TableUtils.getTableClass((String)tableName), (ExcelSheetStrategy.MapperType)ExcelSheetStrategy.MapperType.Insert);
    }

    public void optRow(int curRow, List<String> rowList) throws ExcelException {
        if (curRow == 1) {
            this.columnName = new ArrayList<String>(rowList);
        } else if (curRow > 1) {
            try {
                Object dto = this.dtoClass.newInstance();
                HashMap tls = new HashMap();
                for (int i = 1; i < rowList.size(); ++i) {
                    Object value1;
                    String fieldName = (String)this.columnName.get(i);
                    String fieldValue = rowList.get(i);
                    if (null != this.languages && this.translateLanguageCell(fieldName, fieldValue, tls) || null == (value1 = this.translateCellValue(fieldName, fieldValue, ExcelSheetStrategy.TranslateType.alterColumnTojoinColumn, null))) continue;
                    if (((Class)this.typeMapping.get(fieldName)).getSimpleName().equalsIgnoreCase("DATE")) {
                        value1 = HSSFDateUtil.getJavaCalendar((double)Double.valueOf(value1.toString())).getTime();
                    }
                    BeanUtils.setProperty(dto, (String)fieldName, (Object)value1);
                }
                if (tls.size() != 0) {
                    BeanUtils.setProperty(dto, (String)"__tls", tls);
                }
                this.baseMapper.insertSelective(dto);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ExcelException("\u63d2\u5165\u6570\u636e\u5931\u8d25");
            }
        }
    }

    protected void cleanData() {
        super.cleanData();
        this.baseMapper = null;
    }
}

