/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.service.impl.ImportStrategy;
import com.hand.hap.excel.util.TableUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HapExcelImportImpl
extends DefaultHandler {
    private SharedStringsTable sst;
    private String lastContents;
    private boolean nextIsString;
    private Connection connection;
    private ImportStrategy rowStrategy;
    private int sheetIndex = -1;
    private List<String> rowlist = new ArrayList();
    private int curRow = 0;
    private int curCol = 0;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String preRef = null;
    private String ref = null;
    private String maxRef = null;
    private List<String> tables;

    public HapExcelImportImpl(String tableName, SqlSession sqlSession) throws ExcelException {
        this.connection = sqlSession.getConnection();
        ArrayList allTables = new ArrayList();
        TableUtils.getAllChildrenTable((Class)TableUtils.getTableClass((String)tableName), allTables);
        this.tables = allTables.stream().map(v -> TableUtils.getTable((Class)v).getName()).collect(Collectors.toList());
    }

    public void process(InputStream inputStream) throws ExcelException {
        try {
            OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst);
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)r.getSheetsData();
            while (sheets.hasNext()) {
                this.curRow = 0;
                ++this.sheetIndex;
                InputStream sheet = sheets.next();
                InputSource sheetSource = new InputSource(sheet);
                String sheetName = sheets.getSheetName();
                if (!this.tables.contains(sheetName)) {
                    throw new ExcelException("\u7f3a\u5c11\u8868" + sheetName + "\u7684\u5bfc\u5165\u6743\u9650");
                }
                this.rowStrategy = new ImportStrategy(this.connection, sheetName);
                parser.parse(sheetSource);
                sheet.close();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException(e.getMessage());
        }
        finally {
            this.cleanData();
        }
    }

    public void cleanData() {
        this.sheetIndex = -1;
        this.rowlist = new ArrayList();
        this.curRow = 0;
        this.curCol = 0;
    }

    public XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.sst = sst;
        parser.setContentHandler((ContentHandler)this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("c")) {
            this.preRef = this.preRef == null ? attributes.getValue("r") : this.ref;
            this.ref = attributes.getValue("r");
            String cellType = attributes.getValue("t");
            this.nextIsString = cellType != null && cellType.equals("s");
        }
        this.lastContents = "";
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.nextIsString) {
            int idx = Integer.parseInt(this.lastContents);
            this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            this.nextIsString = false;
        }
        if (name.equals("v")) {
            String value = this.lastContents.trim();
            String string = value = value.equals("") ? " " : value;
            if (!this.ref.equals(this.preRef)) {
                int len = this.countNullCell(this.ref, this.preRef);
                for (int i = 0; i < len; ++i) {
                    this.rowlist.add(this.curCol, "");
                    ++this.curCol;
                }
            }
            this.rowlist.add(this.curCol, value);
            ++this.curCol;
        } else if (name.equals("row")) {
            String value = "";
            if (this.curRow == 1 && this.sheetIndex == 0) {
                this.maxRef = this.ref;
            }
            if (this.maxRef != null) {
                int len = this.countNullCell(this.maxRef, this.ref);
                for (int i = 0; i <= len; ++i) {
                    this.rowlist.add(this.curCol, "");
                    ++this.curCol;
                }
            }
            try {
                if (!this.rowlist.isEmpty()) {
                    this.rowStrategy.optRow(this.curRow, this.rowlist);
                }
            }
            catch (ExcelException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new SAXException("\u5bfc\u5165\u5931\u8d25\uff01Sheet\u9875\uff1a" + this.rowStrategy.tableName + "\uff0c\u7b2c" + (this.curRow + 1) + "\u884c");
            }
            ++this.curRow;
            this.rowlist.clear();
            this.curCol = 0;
            this.preRef = null;
            this.ref = null;
        }
    }

    public int countNullCell(String ref, String preRef) {
        String xfd = ref.replaceAll("\\d+", "");
        String xfd_1 = preRef.replaceAll("\\d+", "");
        xfd = this.fillChar(xfd, 3, '@', true);
        xfd_1 = this.fillChar(xfd_1, 3, '@', true);
        char[] letter = xfd.toCharArray();
        char[] letter_1 = xfd_1.toCharArray();
        int res = (letter[0] - letter_1[0]) * 26 * 26 + (letter[1] - letter_1[1]) * 26 + (letter[2] - letter_1[2]);
        return res - 1;
    }

    String fillChar(String str, int len, char let, boolean isPre) {
        block4: {
            int len_1 = str.length();
            if (len_1 >= len) break block4;
            if (isPre) {
                for (int i = 0; i < len - len_1; ++i) {
                    str = let + str;
                }
            } else {
                for (int i = 0; i < len - len_1; ++i) {
                    str = str + let;
                }
            }
        }
        return str;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
    }
}

