/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.xpath;

import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.xpath.XPathStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XPathRequest {
    private static final String SLASH = "/";
    private Map<String, String> namespaceMapping = new HashMap();
    private List<XPathStep> stepList = new ArrayList();

    public XPathRequest(String request, Map<String, String> mapping) {
        String[] steps;
        if (mapping != null) {
            this.namespaceMapping = mapping;
        }
        for (String step : steps = request.split(SLASH)) {
            this.stepList.add(new XPathStep(step, this));
        }
    }

    public String getNamespace(String prefix) {
        return (String)this.namespaceMapping.get(prefix);
    }

    public boolean validate(XMap node) {
        int len = this.stepList.size();
        if (len > 0) {
            return this.validateStep(node, len - 1);
        }
        return false;
    }

    public boolean validateStep(XMap node, int index) {
        if (index < 0) {
            return true;
        }
        XPathStep step = (XPathStep)this.stepList.get(index);
        if ("*".equals(step.getNodeName())) {
            step = (XPathStep)this.stepList.get(--index);
            node = this.findMatchParentNode(node, step);
        }
        if (step.validate(node)) {
            return node == null ? true : this.validateStep(node.getParent(), index - 1);
        }
        return false;
    }

    public XMap findMatchParentNode(XMap node, XPathStep step) {
        XMap result = null;
        while (node != null) {
            if (node.getName().equals(step.getNodeName())) {
                result = node;
                break;
            }
            node = node.getParent();
        }
        return result;
    }
}

