/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.xpath;

import com.hand.hap.core.web.view.xpath.EqualPredicate;
import com.hand.hap.core.web.view.xpath.IndexPredicate;
import com.hand.hap.core.web.view.xpath.LastExpressPredicate;
import com.hand.hap.core.web.view.xpath.LastPredicate;
import com.hand.hap.core.web.view.xpath.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class XPathPredicate {
    private XPathPredicate() {
    }

    public static Predicate build(String value) {
        EqualPredicate predicate = null;
        if (value.startsWith("[@")) {
            predicate = new EqualPredicate(value.substring(2, value.length() - 1));
        } else if (NumberUtils.isNumber((String)(value = value.substring(1, value.length() - 1)))) {
            predicate = new IndexPredicate(NumberUtils.toInt((String)value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"last()")) {
            predicate = new LastPredicate();
        } else if (StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)"last()")) {
            predicate = new LastExpressPredicate(value);
        }
        return predicate;
    }
}

