/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view;

import com.hand.hap.core.web.view.JacksonUtil;
import com.hand.hap.core.web.view.ScreenTemplate;
import com.hand.hap.core.web.view.ViewTagFactory;
import freemarker.template.Configuration;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, Object> contextMap;
    private ScreenTemplate template;
    private String contextPath;
    private ViewTagFactory screenTagFactory;
    private Configuration configuration;
    private Map<String, Object> jsonConfig = new HashMap(100);
    private Map<String, Object> localMap = new HashMap(100);

    private ViewContext() {
    }

    public ViewContext(Configuration configuration, ViewTagFactory screenTagFactory, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setContextMap(model);
        this.setScreenTagFactory(screenTagFactory);
        this.setConfiguration(configuration);
        this.setRequest(request);
        this.setResponse(response);
        this.initContext();
    }

    public ViewContext createCloneInstance() throws Exception {
        ViewContext instance = new ViewContext();
        instance.setConfiguration(this.getConfiguration());
        instance.setScreenTagFactory(this.getScreenTagFactory());
        instance.setContextMap(this.getContextMap());
        instance.setRequest(this.getRequest());
        instance.setRequest(this.getRequest());
        instance.setContextPath(this.getContextPath());
        return instance;
    }

    public void initContext() throws Exception {
        this.setContextPath(this.request.getContextPath());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.put("request", (Object)request);
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public void setContextMap(Map<String, Object> model) {
        this.contextMap = model;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ViewTagFactory getScreenTagFactory() {
        return this.screenTagFactory;
    }

    public void setScreenTagFactory(ViewTagFactory screenTagFactory) {
        this.screenTagFactory = screenTagFactory;
    }

    public String getUserAgent() {
        return this.getRequest().getHeader("User-Agent");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void put(String key, Object value) {
        this.localMap.put(key, value);
    }

    public Object get(String key) {
        return this.localMap.get(key);
    }

    public Map<String, Object> getMap() {
        return this.localMap;
    }

    public Map<String, Object> getFreeMarkerModel() throws TemplateModelException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.getContextMap());
        result.putAll(this.getMap());
        return result;
    }

    public String getJsonConfig() throws Exception {
        return JacksonUtil.getInstance().writeValueAsString((Object)this.jsonConfig);
    }

    public void removeJsonConfig(String key) {
        this.jsonConfig.remove(key);
    }

    public void addJsonConfig(String key, Object value) {
        if (key != null && value != null) {
            this.jsonConfig.put(key, value);
        }
    }

    public ScreenTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ScreenTemplate template) {
        this.template = template;
    }
}

