/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.core.web.DefaultFreeMarkerView;
import com.hand.hap.system.dto.Form;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;

public class FormView
extends DefaultFreeMarkerView {
    protected final Logger logger = LoggerFactory.getLogger(FormView.class);
    private CacheManager cacheManager;
    private Cache<Form> formCache;

    protected void initServletContext(ServletContext servletContext) throws BeansException {
        super.initServletContext(servletContext);
        this.cacheManager = (CacheManager)this.autodetectScreenTagFactory(CacheManager.class);
        this.formCache = this.cacheManager.getCache("form");
    }

    protected Object autodetectScreenTagFactory(Class<?> clazz) throws BeansException {
        try {
            return BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), clazz, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single ViewTagFactory bean in this web application context!", (Throwable)ex);
        }
    }

    protected void doRender(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering FreeMarker template [{}] in FreeMarkerView '{}'", (Object)this.getUrl(), (Object)this.getBeanName());
        }
        this.processTemplate(model, request, response);
    }

    protected void processTemplate(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleHash fmModel = this.buildTemplateModel(model, request, response);
        try (PrintWriter writer = response.getWriter();){
            String name = this.getUrl();
            Boolean isPreview = false;
            if (name.indexOf("preview/") >= 0) {
                isPreview = true;
                name = name.replace("preview/", "");
            }
            Form form = null;
            if (name != null) {
                form = (Form)this.formCache.getValue(StringUtils.upperCase((String)StringUtils.substringBefore((String)name, (String)".form")));
            }
            if (form != null) {
                if (!isPreview.booleanValue() && form.getIsPublish().equals("N")) {
                    ((Writer)writer).write("Form not publish!");
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<#include \"/include/header.html\">");
                    sb.append("<body>");
                    sb.append(form.getContent());
                    sb.append("</body></html>");
                    Template template = new Template(name, sb.toString(), this.getConfiguration());
                    template.process((Object)fmModel, (Writer)writer);
                }
            } else {
                ((Writer)writer).write("Form not found!");
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Failed to parse screen template for URL [" + this.getUrl() + "]", (Throwable)e);
            }
            throw e;
        }
    }

    public boolean checkResource(Locale locale) throws Exception {
        String name = this.getUrl();
        return name.endsWith(".form");
    }
}

