/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.util;

import java.util.TimeZone;

public final class TimeZoneUtil {
    private static ThreadLocal<TimeZone> local = new ThreadLocal();

    private TimeZoneUtil() {
    }

    public static TimeZone getTimeZone() {
        TimeZone timeZone = (TimeZone)local.get();
        return timeZone != null ? timeZone : TimeZone.getDefault();
    }

    public static void setTimeZone(TimeZone timeZone) {
        local.set(timeZone);
    }

    public static String toGMTFormat(TimeZone timeZone) {
        long of = timeZone.getRawOffset();
        if (of == 0L) {
            return "GMT";
        }
        if (of > 0L) {
            return String.format("GMT+%02d%02d", of / 3600000L, of / 60000L % 60L);
        }
        of = Math.abs(of);
        return String.format("GMT-%02d%02d", of / 3600000L, of / 60000L % 60L);
    }
}

