/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.core.components.DatabaseExceptionTranslator;
import com.hand.hap.system.dto.BaseDTO;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OvnInterceptor
implements Interceptor {
    private DatabaseExceptionTranslator databaseExceptionTranslator;

    public Object intercept(Invocation invocation) throws Throwable {
        Map map;
        Object[] args = invocation.getArgs();
        Object domain = args[1];
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (Exception e) {
            if (null == this.databaseExceptionTranslator) {
                this.databaseExceptionTranslator = (DatabaseExceptionTranslator)ApplicationContextHelper.getApplicationContext().getBean(DatabaseExceptionTranslator.class);
            }
            throw this.databaseExceptionTranslator.translateException(e, domain);
        }
        if (domain instanceof MapperMethod.ParamMap && (map = (Map)domain).containsKey("dto")) {
            domain = ((Map)domain).get("dto");
        }
        MappedStatement mappedStatement = (MappedStatement)args[0];
        if (!(domain instanceof BaseDTO)) {
            return result;
        }
        BaseDTO baseDTO = (BaseDTO)domain;
        Long ovn = baseDTO.getObjectVersionNumber();
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            baseDTO.setObjectVersionNumber(Long.valueOf(1L));
            return result;
        }
        if (ovn == null) {
            return result;
        }
        if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
            baseDTO.setObjectVersionNumber(Long.valueOf(ovn + 1L));
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

