/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.ITlTableNameProvider;
import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.core.impl.DefaultTlTableNameProvider;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.mapperhelper.MultipleJdbc3KeyGenerator;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Language;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Table;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MultiLanguageInterceptor
implements Interceptor {
    private ITlTableNameProvider tableNameProvider = DefaultTlTableNameProvider.getInstance();
    private ILanguageProvider languageProvider;
    private Logger logger = LoggerFactory.getLogger(MultiLanguageInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof Executor) {
            Map map;
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            MetaObject msObject = SystemMetaObject.forObject((Object)mappedStatement);
            KeyGenerator keyGenerator = mappedStatement.getKeyGenerator();
            if (keyGenerator instanceof Jdbc3KeyGenerator) {
                msObject.setValue("keyGenerator", (Object)new MultipleJdbc3KeyGenerator());
            }
            Object domain = invocation.getArgs()[1];
            Criteria criteria = null;
            if (domain instanceof MapperMethod.ParamMap && (map = (Map)domain).containsKey("criteria")) {
                criteria = (Criteria)((Map)domain).get("criteria");
                domain = ((Map)domain).get("dto");
            }
            if (domain instanceof BaseDTO) {
                BaseDTO dtoObj = (BaseDTO)domain;
                if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT || mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
                    Object obj = invocation.proceed();
                    this.proceedMultiLanguage(dtoObj, invocation, mappedStatement, criteria);
                    return obj;
                }
                if (mappedStatement.getSqlCommandType() == SqlCommandType.DELETE) {
                    Object obj = invocation.proceed();
                    this.proceedDeleteMultiLanguage(dtoObj, invocation);
                    return obj;
                }
            }
            return invocation.proceed();
        }
        return invocation.proceed();
    }

    private void proceedMultiLanguage(BaseDTO parameterObject, Invocation invocation, MappedStatement mappedStatement, Criteria criteria) throws Exception {
        List updateFields = criteria != null ? criteria.getUpdateFields() : null;
        Class<?> clazz = parameterObject.getClass();
        MultiLanguage multiLanguageTable = clazz.getAnnotation(MultiLanguage.class);
        if (multiLanguageTable == null) {
            return;
        }
        if (null == this.languageProvider) {
            this.languageProvider = (ILanguageProvider)ApplicationContextHelper.getApplicationContext().getBean(ILanguageProvider.class);
        }
        Table table = clazz.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)"annotation @Table not found!");
        String tableName = table.name();
        Assert.hasText((String)tableName, (String)"@Table name not found!");
        tableName = this.tableNameProvider.getTlTableName(tableName);
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            this.proceedInsertMultiLanguage(tableName, parameterObject, (Executor)invocation.getTarget());
        } else if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
            if (parameterObject.get__tls().isEmpty()) {
                this.proceedUpdateMultiLanguage(tableName, parameterObject, (Executor)invocation.getTarget(), updateFields);
            } else {
                this.proceedUpdateMultiLanguage2(tableName, parameterObject, (Executor)invocation.getTarget(), updateFields);
            }
        }
    }

    private void proceedDeleteMultiLanguage(BaseDTO parameterObject, Invocation invocation) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        MultiLanguage multiLanguageTable = clazz.getAnnotation(MultiLanguage.class);
        if (multiLanguageTable == null) {
            return;
        }
        if (null == this.languageProvider) {
            this.languageProvider = (ILanguageProvider)ApplicationContextHelper.getApplicationContext().getBean(ILanguageProvider.class);
        }
        Table table = clazz.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)"annotation @Table not found!");
        String tableName = table.name();
        Assert.hasText((String)tableName, (String)"@Table name not found!");
        tableName = this.tableNameProvider.getTlTableName(tableName);
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        for (EntityField f : DTOClassInfo.getIdFields(clazz)) {
            Object v = PropertyUtils.getProperty((Object)parameterObject, (String)f.getName());
            keys.add(DTOClassInfo.getColumnName((EntityField)f) + "=?");
            objs.add(v);
        }
        for (Object e : objs) {
            if (e != null) continue;
            return;
        }
        if (keys.size() > 0) {
            Executor executor = (Executor)invocation.getTarget();
            StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
            stringBuilder.append(tableName).append(" WHERE ").append(StringUtils.join(keys, (String)" AND "));
            this.executeSql(executor.getTransaction().getConnection(), stringBuilder.toString(), objs);
        }
    }

    private void proceedInsertMultiLanguage(String tableName, BaseDTO parameterObject, Executor executor) throws Exception {
        EntityField[] mlFields;
        Class<?> clazz = parameterObject.getClass();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> placeholders = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + "(");
        for (EntityField f : DTOClassInfo.getIdFields(clazz)) {
            String columnName = DTOClassInfo.getColumnName((EntityField)f);
            keys.add(columnName);
            placeholders.add("?");
            objs.add(PropertyUtils.getProperty((Object)parameterObject, (String)f.getName()));
        }
        keys.add("LANG");
        placeholders.add("?");
        objs.add(null);
        for (EntityField f : mlFields = DTOClassInfo.getMultiLanguageFields(clazz)) {
            keys.add(DTOClassInfo.getColumnName((EntityField)f));
            placeholders.add("?");
            Map tls = (Map)parameterObject.get__tls().get(f.getName());
            if (tls == null) {
                objs.add(PropertyUtils.getProperty((Object)parameterObject, (String)f.getName()));
                continue;
            }
            objs.add(null);
        }
        keys.add("CREATED_BY");
        placeholders.add("" + parameterObject.getCreatedBy());
        keys.add("CREATION_DATE");
        placeholders.add("CURRENT_TIMESTAMP");
        keys.add("LAST_UPDATED_BY");
        placeholders.add("" + parameterObject.getCreatedBy());
        keys.add("LAST_UPDATE_DATE");
        placeholders.add("CURRENT_TIMESTAMP");
        sql.append(StringUtils.join(keys, (String)","));
        sql.append(") VALUES (").append(StringUtils.join(placeholders, (String)",")).append(")");
        List languages = this.languageProvider.getSupportedLanguages();
        for (Language language : languages) {
            objs.set(objs.size() - mlFields.length - 1, language.getLangCode());
            for (int i = 0; i < mlFields.length; ++i) {
                int idx = objs.size() - mlFields.length + i;
                Map tls = (Map)parameterObject.get__tls().get(mlFields[i].getName());
                if (tls == null) continue;
                objs.set(idx, tls.get(language.getLangCode()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Insert TL(Batch):{}", (Object)sql.toString());
                this.logger.debug("Parameters:{}", (Object)StringUtils.join(objs, (String)", "));
            }
            this.executeSql(executor.getTransaction().getConnection(), sql.toString(), objs);
        }
    }

    private void proceedUpdateMultiLanguage(String tableName, BaseDTO parameterObject, Executor executor, List<String> updateFields) throws Exception {
        Connection connection;
        int updateCount;
        Class<?> clazz = parameterObject.getClass();
        ArrayList<String> sets = new ArrayList<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET ");
        for (EntityField field : DTOClassInfo.getMultiLanguageFields(clazz)) {
            Object value;
            if (null != updateFields && !updateFields.isEmpty() && !updateFields.contains(field.getName()) || (value = PropertyUtils.getProperty((Object)parameterObject, (String)field.getName())) == null) continue;
            sets.add(DTOClassInfo.getColumnName((EntityField)field) + "=?");
            objs.add(value);
        }
        if (sets.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("None multi language field has TL value. skip update.");
            }
            return;
        }
        sets.add("LAST_UPDATED_BY=" + parameterObject.getLastUpdatedBy());
        sets.add("LAST_UPDATE_DATE=CURRENT_TIMESTAMP");
        for (EntityField field : DTOClassInfo.getIdFields(clazz)) {
            keys.add(DTOClassInfo.getColumnName((EntityField)field) + "=?");
            objs.add(PropertyUtils.getProperty((Object)parameterObject, (String)field.getName()));
        }
        keys.add("LANG=?");
        IRequest iRequest = RequestHelper.getCurrentRequest((boolean)true);
        objs.add(iRequest.getLocale());
        sql.append(StringUtils.join(sets, (String)","));
        sql.append(" WHERE ").append(StringUtils.join(keys, (String)" AND "));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Update TL(Classic):{}", (Object)sql.toString());
            this.logger.debug("Parameters:{}", (Object)StringUtils.join(objs, (String)","));
        }
        if ((updateCount = this.executeSql(connection = executor.getTransaction().getConnection(), sql.toString(), objs)) < 1) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Update TL failed(Classic). update count:" + updateCount);
            }
            this.doInsertForMissingTlData(tableName, iRequest.getLocale(), parameterObject, connection);
        }
    }

    private void proceedUpdateMultiLanguage2(String tableName, BaseDTO parameterObject, Executor executor, List<String> updateFields) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        ArrayList<String> sets = new ArrayList<String>();
        ArrayList<String> updateFieldNames = new ArrayList<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET ");
        for (EntityField field : DTOClassInfo.getMultiLanguageFields(clazz)) {
            if (null != updateFields && !updateFields.isEmpty() && !updateFields.contains(field.getName())) continue;
            Map tls = (Map)parameterObject.get__tls().get(field.getName());
            if (tls == null) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("TL value for field '{}' not exists.", (Object)field.getName());
                continue;
            }
            sets.add(DTOClassInfo.getColumnName((EntityField)field) + "=?");
            updateFieldNames.add(field.getName());
            objs.add(null);
        }
        if (sets.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("None multi language field has TL value. skip update.");
            return;
        }
        sets.add("LAST_UPDATED_BY=" + parameterObject.getLastUpdatedBy());
        sets.add("LAST_UPDATE_DATE=CURRENT_TIMESTAMP");
        for (EntityField field : DTOClassInfo.getIdFields(clazz)) {
            keys.add(DTOClassInfo.getColumnName((EntityField)field) + "=?");
            objs.add(PropertyUtils.getProperty((Object)parameterObject, (String)field.getName()));
        }
        keys.add("LANG=?");
        objs.add(null);
        sql.append(StringUtils.join(sets, (String)","));
        sql.append(" WHERE ").append(StringUtils.join(keys, (String)" AND "));
        Connection connection = executor.getTransaction().getConnection();
        List languages = this.languageProvider.getSupportedLanguages();
        for (Language language : languages) {
            int updateCount;
            for (int i = 0; i < updateFieldNames.size(); ++i) {
                Map tls = (Map)parameterObject.get__tls().get(updateFieldNames.get(i));
                objs.set(i, tls.get(language.getLangCode()));
            }
            objs.set(objs.size() - 1, language.getLangCode());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Update TL(Batch):{}", (Object)sql.toString());
                this.logger.debug("Parameters:{}", (Object)StringUtils.join(objs, (String)", "));
            }
            if ((updateCount = this.executeSql(connection, sql.toString(), objs)) >= 1) continue;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Update TL failed(Batch). update count:{},lang:{}", (Object)updateCount, (Object)language.getLangCode());
            }
            this.doInsertForMissingTlData(tableName, language.getLangCode(), parameterObject, connection);
        }
    }

    private void doInsertForMissingTlData(String tableName, String lang, BaseDTO parameterObject, Connection connection) throws Exception {
        Class<?> clazz = parameterObject.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tableName).append(" (");
        ArrayList<Object> values = new ArrayList<Object>();
        int pn = 0;
        for (EntityField f : DTOClassInfo.getIdFields(clazz)) {
            sb.append(DTOClassInfo.getColumnName((EntityField)f)).append(",");
            values.add(PropertyUtils.getProperty((Object)parameterObject, (String)f.getName()));
            ++pn;
        }
        sb.append("LANG");
        ++pn;
        values.add(lang);
        Map tls = parameterObject.get__tls();
        for (EntityField f : DTOClassInfo.getMultiLanguageFields(clazz)) {
            sb.append(",").append(DTOClassInfo.getColumnName((EntityField)f));
            if (tls != null && tls.get(f.getName()) != null) {
                values.add(((Map)tls.get(f.getName())).get(lang));
            } else {
                values.add(PropertyUtils.getProperty((Object)parameterObject, (String)f.getName()));
            }
            ++pn;
        }
        sb.append(",CREATED_BY");
        values.add(parameterObject.getCreatedBy());
        sb.append(",CREATION_DATE");
        sb.append(",LAST_UPDATED_BY");
        values.add(parameterObject.getLastUpdatedBy());
        sb.append(",LAST_UPDATE_DATE");
        sb.append(") VALUES (");
        for (int i = 0; i < pn; ++i) {
            sb.append("?,");
        }
        sb.append("?");
        sb.append(",CURRENT_TIMESTAMP");
        sb.append(",?");
        sb.append(",CURRENT_TIMESTAMP");
        sb.append(")");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Insert Missing TL record:" + sb.toString());
            this.logger.debug("Parameters:" + StringUtils.join(values, (String)", "));
        }
        this.executeSql(connection, sb.toString(), values);
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public ITlTableNameProvider getTableNameProvider() {
        return this.tableNameProvider;
    }

    public void setTableNameProvider(ITlTableNameProvider tableNameProvider) {
        this.tableNameProvider = tableNameProvider;
    }

    protected int executeSql(Connection connection, String sql, List<Object> params) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            int i = 1;
            for (Object obj : params) {
                ps.setObject(i++, obj);
            }
            ps.execute();
            int n = ps.getUpdateCount();
            return n;
        }
    }
}

