/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.audit.service.IAuditService;
import com.hand.hap.audit.service.IAuditTableNameProvider;
import com.hand.hap.audit.service.impl.DefaultAuditTableNameProvider;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.ITlTableNameProvider;
import com.hand.hap.core.annotation.AuditEnabled;
import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.core.impl.DefaultTlTableNameProvider;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.interceptor.AuditInterceptor;
import com.hand.hap.core.web.view.IDGenerator;
import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Language;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AuditInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(AuditInterceptor.class);
    public static final ThreadLocal<String> LOCAL_AUDIT_SESSION = new ThreadLocal();
    private ILanguageProvider languageProvider;
    private ApplicationContext beanFactory;
    private ITlTableNameProvider tableNameProvider = DefaultTlTableNameProvider.getInstance();
    private IAuditService iAuditService;
    @Autowired(required=false)
    private IAuditTableNameProvider auditTableNameProvider = DefaultAuditTableNameProvider.instance;

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object param = invocation.getArgs()[1];
        Object targetDto = null;
        if (param instanceof Map) {
            Map temp = (Map)param;
            for (Map.Entry entry : temp.entrySet()) {
                if (!"dto".equals(entry.getKey())) continue;
                targetDto = temp.get("dto");
                break;
            }
        } else {
            targetDto = param;
        }
        if (null == targetDto || !(targetDto instanceof BaseDTO)) {
            return invocation.proceed();
        }
        if (targetDto.getClass().getAnnotation(AuditEnabled.class) == null) {
            return invocation.proceed();
        }
        BaseDTO dto = (BaseDTO)targetDto;
        SqlCommandType type = mappedStatement.getSqlCommandType();
        switch (1.$SwitchMap$org$apache$ibatis$mapping$SqlCommandType[type.ordinal()]) {
            case 1: 
            case 2: {
                result = invocation.proceed();
                this.doAudit(dto, type.name(), mappedStatement, param);
                break;
            }
            case 3: {
                this.doAudit(dto, type.name(), mappedStatement, param);
                result = invocation.proceed();
                break;
            }
            default: {
                result = invocation.proceed();
            }
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private void doAudit(BaseDTO dto, String type, MappedStatement mappedStatement, Object param) throws Exception {
        this.loadService();
        Class<?> clazz = dto.getClass();
        String tableName = this.getTableName(clazz);
        if (StringUtils.isBlank((String)tableName)) {
            return;
        }
        EntityField[] ids = DTOClassInfo.getIdFields(clazz);
        if (ids.length == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Can not get PrimaryKey(s) of dto class:" + clazz);
            }
            return;
        }
        boolean hasExtensionAttribute = true;
        if (clazz.isAnnotationPresent(ExtensionAttribute.class)) {
            ExtensionAttribute extensionAttribute = clazz.getAnnotation(ExtensionAttribute.class);
            hasExtensionAttribute = !extensionAttribute.disable();
        }
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<String> valueFields = new ArrayList<String>();
        for (Map.Entry entry : DTOClassInfo.getEntityFields(clazz).entrySet()) {
            if ("lastUpdatedBy".equalsIgnoreCase(((EntityField)entry.getValue()).getName()) || ((EntityField)entry.getValue()).isAnnotationPresent(Transient.class) || ((EntityField)entry.getValue()).getName().startsWith("attribute") && !hasExtensionAttribute) continue;
            cols.add(DTOClassInfo.getColumnName((EntityField)((EntityField)entry.getValue())));
            valueFields.add("#{" + DTOClassInfo.getColumnName((EntityField)((EntityField)entry.getValue())) + "}");
        }
        EntityField[] entityFields = DTOClassInfo.getMultiLanguageFields(clazz);
        boolean isMultiLanguageTable = clazz.getAnnotation(MultiLanguage.class) != null;
        IRequest request = RequestHelper.getCurrentRequest((boolean)true);
        String localLanguage = request.getLocale();
        ArrayList<String> dynFields = new ArrayList<String>();
        HashMap<String, Object> auditParam = new HashMap<String, Object>(50);
        HashMap updateParam = new HashMap(50);
        BoundSql boundSql = mappedStatement.getBoundSql(param);
        String sql = boundSql.getSql();
        auditParam.put("sql", sql);
        Map wps = this.getWhereClause(mappedStatement, param, isMultiLanguageTable);
        for (Map.Entry entry : wps.entrySet()) {
            auditParam.put((String)entry.getKey(), entry.getValue());
            if ("objectVersionNumber".equals(entry.getKey()) && !"delete".equalsIgnoreCase(type)) {
                updateParam.put(entry.getKey(), Integer.parseInt(entry.getValue().toString()) - 1);
                continue;
            }
            updateParam.put(entry.getKey(), entry.getValue());
        }
        String alias = wps.get("_ALIAS") == null ? "" : wps.get("_ALIAS").toString();
        for (String s : cols) {
            if (isMultiLanguageTable) {
                for (EntityField entityField : entityFields) {
                    if (!DTOClassInfo.camelToUnderLine((String)entityField.getName()).toLowerCase().equals(s.toLowerCase())) continue;
                    s = "TL." + s;
                    break;
                }
                dynFields.add(s.contains("TL.") ? s : alias + "." + s);
                continue;
            }
            dynFields.add(s);
        }
        if (isMultiLanguageTable) {
            String string = this.tableNameProvider.getTlTableName(tableName);
            auditParam.put("_MAJOR_FIELD", DTOClassInfo.camelToUnderLine((String)ids[0].getName()).toUpperCase());
            auditParam.put("_MAJOR_FIELD_B", alias + "." + DTOClassInfo.camelToUnderLine((String)ids[0].getName()).toUpperCase());
            auditParam.put("_LANGUAGE_TABLE_NAME", string);
        }
        AuditEnabled auditEnabled = clazz.getAnnotation(AuditEnabled.class);
        String auditTableName = StringUtils.defaultIfEmpty((String)auditEnabled.auditTable(), (String)this.auditTableNameProvider.getAuditTableName(tableName));
        auditParam.put("_AUDIT_TABLE_NAME", auditTableName);
        auditParam.put("_COLS", cols);
        auditParam.put("_FIELD_VALUE", valueFields);
        auditParam.put("_AUDIT_TYPE", type);
        auditParam.put("_AUDIT_SESSION_ID", IDGenerator.getInstance().generate());
        auditParam.put("_DYN_FIELDS", dynFields);
        auditParam.put("_BASE_TABLE_NAME", tableName + " " + alias);
        auditParam.put("_LAST_UPDATED_BY", request.getUserId());
        updateParam.put("_AUDIT_TABLE_NAME", auditTableName + " " + alias);
        updateParam.put("_ALIAS", alias);
        if (isMultiLanguageTable) {
            List languages = this.languageProvider.getSupportedLanguages();
            for (Language language : languages) {
                auditParam.put("_LANGUAGE", language.getLangCode());
                updateParam.put("_LANG", language.getLangCode());
                try {
                    this.doDB(auditParam, updateParam);
                }
                catch (Exception exception) {}
            }
        } else {
            auditParam.put("_LANGUAGE", localLanguage);
            updateParam.put("_LANG", localLanguage);
            try {
                this.doDB(auditParam, updateParam);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Map<String, Object> getWhereClause(MappedStatement mappedStatement, Object param, boolean isMulti) throws JSQLParserException, NoSuchFieldException {
        BoundSql boundSql = mappedStatement.getBoundSql(param);
        String whereExpression = this.getWhereExpression(boundSql.getSql());
        int whereParamNum = StringUtils.countMatches((String)whereExpression, (String)"?");
        List parameterMappings = boundSql.getParameterMappings();
        Configuration configuration = mappedStatement.getConfiguration();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        String whereClause = whereExpression;
        HashMap<String, Object> wps = new HashMap<String, Object>(10);
        this.logger.debug("Audit 0001:" + parameterMappings.size());
        this.logger.debug("Audit 0002:" + whereParamNum);
        if (parameterMappings != null) {
            if (whereParamNum == 0) {
                String majorField = null;
                Object value = null;
                EntityField[] ids = DTOClassInfo.getIdFields(param.getClass());
                majorField = ids[0].getName();
                try {
                    Field f = param.getClass().getDeclaredField(majorField);
                    f.setAccessible(true);
                    value = f.get(param);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                wps.put("_ALIAS", "BASE_TABLE");
                wps.put(majorField, value);
                String field = DTOClassInfo.camelToUnderLine((String)majorField);
                wps.put("_WHERE_CLAUSE", "BASE_TABLE." + field + "=#{" + majorField + "}");
                return wps;
            }
            for (int i = parameterMappings.size() - whereParamNum; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (param == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(param.getClass())) {
                    value = param;
                } else {
                    MetaObject typeHandler = configuration.newMetaObject(param);
                    value = typeHandler.getValue(propertyName);
                }
                if (propertyName.startsWith("dto.")) {
                    propertyName = propertyName.replaceFirst("dto.", "");
                }
                wps.put(propertyName, value);
                whereClause = whereClause.replaceFirst("\\?", "#{" + propertyName + "}");
            }
            String alias = "BASE_TABLE";
            if (isMulti) {
                Object[] wheres = whereClause.split(" AND ");
                int j = wheres.length;
                for (int i = 0; i < j; ++i) {
                    String fieldName = wheres[i];
                    if (StringUtils.contains((String)fieldName, (String)".")) {
                        String[] fieldsStr = fieldName.split("\\.");
                        fieldName = fieldsStr[fieldsStr.length - 1];
                    }
                    wheres[i] = alias + "." + fieldName;
                }
                whereClause = StringUtils.join((Object[])wheres, (String)" AND ");
            } else if (StringUtils.contains((String)whereClause, (String)".")) {
                alias = whereClause.substring(0, whereClause.indexOf("."));
            }
            wps.put("_ALIAS", alias);
            wps.put("_WHERE_CLAUSE", whereClause);
        }
        return wps;
    }

    private String getWhereExpression(String sql) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Insert) {
            return "";
        }
        Expression whereExpression = null;
        if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            whereExpression = updateStatement.getWhere();
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            whereExpression = deleteStatement.getWhere();
        }
        if (null == whereExpression) {
            return "";
        }
        return StringUtils.defaultIfBlank((String)whereExpression.toString(), (String)"");
    }

    private String getTableName(Class clazz) {
        Table tbl = clazz.getAnnotation(Table.class);
        if (tbl == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("@Table not found on dto class:" + clazz);
            }
            return null;
        }
        String tableName = tbl.name();
        if (StringUtils.isBlank((String)tableName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Can not get tableName of dto class:" + clazz);
            }
            return null;
        }
        return tableName;
    }

    private void doDB(Map insertMap, Map updateMap) throws SQLException {
        this.iAuditService.insertAudit(updateMap, insertMap);
    }

    private void loadService() {
        if (null == this.beanFactory) {
            this.beanFactory = ApplicationContextHelper.getApplicationContext();
        }
        if (this.iAuditService == null) {
            this.iAuditService = (IAuditService)this.beanFactory.getBean(IAuditService.class);
        }
        if (null == this.languageProvider) {
            this.languageProvider = (ILanguageProvider)this.beanFactory.getBean(ILanguageProvider.class);
        }
    }

    public static String generateAndSetAuditSessionId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static void clearAuditSessionId() {
        LOCAL_AUDIT_SESSION.remove();
    }
}

