/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.components.DatabaseExceptionTranslator;
import com.hand.hap.core.impl.RequestHelper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DatabaseExceptionTranslator {
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    @Autowired
    private MessageSource messageSource;
    private static Logger logger = LoggerFactory.getLogger(DatabaseExceptionTranslator.class);
    Map<Integer, AbstractDbExceptionHandler> HANDLER_MAPPING_U = new HashMap();
    Map<Integer, AbstractDbExceptionHandler> HANDLER_MAPPING_N = new HashMap();
    OracleDbExceptionHandler oracleDbExceptionHandler = new OracleDbExceptionHandler(this);
    MySqlDbExceptionHandler mySqlDbExceptionHandler = new MySqlDbExceptionHandler(this);
    SqlServerDbExceptionHandler sqlServerDbExceptionHandler = new SqlServerDbExceptionHandler(this);

    public DatabaseExceptionTranslator() {
        this.HANDLER_MAPPING_U.put(1, this.oracleDbExceptionHandler);
        this.HANDLER_MAPPING_U.put(1062, this.mySqlDbExceptionHandler);
        this.HANDLER_MAPPING_U.put(2627, this.sqlServerDbExceptionHandler);
        this.HANDLER_MAPPING_U.put(2601, this.sqlServerDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1364, this.mySqlDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1048, this.mySqlDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1400, this.oracleDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1407, this.oracleDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(515, this.sqlServerDbExceptionHandler);
    }

    public Exception translateException(Exception exception, Object domain) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        if (!(rootCause instanceof SQLException)) {
            return exception;
        }
        SQLException sqlException = (SQLException)rootCause;
        int errorCode = sqlException.getErrorCode();
        logger.error("SQLException Error Code: " + errorCode);
        logger.error(sqlException.getMessage(), (Throwable)sqlException);
        try {
            AbstractDbExceptionHandler handler = (AbstractDbExceptionHandler)this.HANDLER_MAPPING_U.get(errorCode);
            if (handler != null) {
                return handler.handleUniqueException(sqlException, domain);
            }
            handler = (AbstractDbExceptionHandler)this.HANDLER_MAPPING_N.get(errorCode);
            if (handler != null) {
                return handler.handleNullException(sqlException, domain);
            }
            logger.warn("can not translate database exception, error code:{}, message:{}", (Object)errorCode, (Object)sqlException.getMessage());
        }
        catch (Exception e) {
            logger.error("error while translate database exception", (Throwable)e);
            return exception;
        }
        return exception;
    }

    private static Locale getLocale() {
        IRequest iRequest = RequestHelper.getCurrentRequest((boolean)true);
        if (StringUtils.isEmpty((String)iRequest.getLocale())) {
            iRequest.setLocale("zh_CN");
        }
        String[] ss = iRequest.getLocale().split("_");
        return new Locale(ss[0], ss[1]);
    }

    static /* synthetic */ Locale access$000() {
        return DatabaseExceptionTranslator.getLocale();
    }

    static /* synthetic */ MessageSource access$100(DatabaseExceptionTranslator x0) {
        return x0.messageSource;
    }

    static /* synthetic */ DataSource access$200(DatabaseExceptionTranslator x0) {
        return x0.dataSource;
    }

    static /* synthetic */ Logger access$300() {
        return logger;
    }
}

