/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.core.BaseConstants;
import com.hand.hap.message.profile.SystemConfigListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.util.WebUtils;

@Component
public class CaptchaConfig
implements SystemConfigListener,
BaseConstants {
    public static final String LOGIN_KEY = "loginKey";
    private static final int CAPTCHA_EXPIRE = 2592000;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private String redisCatalog = "hap:cache:login:";
    private boolean enableCaptcha = true;
    private Integer wrongTimes = 0;
    private Integer expire = 2592000;

    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public List<String> getAcceptedProfiles() {
        return Arrays.asList("CAPTCHA");
    }

    public void updateProfile(String configCode, String configValue) {
        if ("DISABLE".equalsIgnoreCase(configValue)) {
            this.enableCaptcha = false;
            this.wrongTimes = 0;
        } else if ("ENABLE".equalsIgnoreCase(configValue)) {
            this.enableCaptcha = true;
        } else if ("AFTER3".equalsIgnoreCase(configValue)) {
            this.enableCaptcha = false;
            this.wrongTimes = 3;
        }
    }

    public Integer getWrongTimes() {
        return this.wrongTimes;
    }

    public void updateLoginFailureInfo(Cookie cookie) {
        if (cookie != null) {
            String failureTimes = (String)this.redisTemplate.opsForValue().get((Object)(this.redisCatalog + cookie.getValue()));
            if (failureTimes == null) {
                this.redisTemplate.opsForValue().set((Object)(this.redisCatalog + cookie.getValue()), (Object)this.wrongTimes.toString(), (long)this.expire.intValue(), TimeUnit.SECONDS);
            } else {
                Integer times = Integer.parseInt(failureTimes);
                if (times < this.wrongTimes) {
                    this.redisTemplate.opsForValue().increment((Object)(this.redisCatalog + cookie.getValue()), 1L);
                }
            }
        }
    }

    public void resetLoginFailureInfo(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)LOGIN_KEY);
        if (cookie != null) {
            cookie.setMaxAge(this.expire.intValue());
            cookie.setPath(StringUtils.defaultIfEmpty((String)request.getContextPath(), (String)"/"));
            response.addCookie(cookie);
            this.redisTemplate.opsForValue().set((Object)(this.redisCatalog + cookie.getValue()), (Object)"0", (long)this.expire.intValue(), TimeUnit.SECONDS);
        }
    }

    public boolean isEnableCaptcha(Cookie cookie) {
        boolean enable = this.enableCaptcha;
        if (!this.enableCaptcha && this.wrongTimes > 0 && cookie != null) {
            String failureTimes = (String)this.redisTemplate.opsForValue().get((Object)(this.redisCatalog + cookie.getValue()));
            if (failureTimes != null) {
                Integer times = Integer.parseInt(failureTimes);
                if (times.equals(this.wrongTimes)) {
                    enable = true;
                }
            } else {
                enable = true;
            }
        }
        return enable;
    }
}

