/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.code.rule.service.impl;

import com.hand.hap.cache.impl.SysCodeRuleCache;
import com.hand.hap.code.rule.CodeRuleConstants;
import com.hand.hap.code.rule.ICodeRuleResetStrategy;
import com.hand.hap.code.rule.dto.CodeRulesLine;
import com.hand.hap.code.rule.exception.CodeRuleException;
import com.hand.hap.code.rule.service.ICodeRulesLineService;
import com.hand.hap.code.rule.service.ISysCodeRuleProcessService;
import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.core.interceptor.SecurityTokenInterceptor;
import com.hand.hap.core.util.FreemarkerUtil;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.dto.BaseDTO;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SysCodeRuleProcessService
implements ISysCodeRuleProcessService,
AppContextInitListener {
    private final Logger logger = LoggerFactory.getLogger(SysCodeRuleProcessService.class);
    @Autowired
    private SysCodeRuleCache ruleCache;
    @Autowired
    private ICodeRulesLineService codeRulesLineService;
    private List<ICodeRuleResetStrategy> strategyList;

    public String getRuleCode(String ruleCode) throws CodeRuleException {
        return this.getRuleCode(ruleCode, null);
    }

    public String getRuleCode(String ruleCode, Map<String, String> variables) throws CodeRuleException {
        List lineList = (List)this.ruleCache.getValue(ruleCode);
        if (lineList == null || lineList.isEmpty()) {
            this.logger.error("can not find codeRule from cache");
            throw new CodeRuleException("can not find codeRule from cache", "can't find cache by :" + ruleCode);
        }
        StringBuilder result = new StringBuilder();
        Date now = new Date();
        lineList.forEach(line -> {
            line.setRuleCode(ruleCode);
            String fieldVaule = null;
            switch (line.getFiledType()) {
                case "SEQUENCE": {
                    fieldVaule = this.getSeq(line);
                    break;
                }
                case "VARIABLE": 
                case "CONSTANT": {
                    fieldVaule = line.getFiledValue();
                    break;
                }
                case "DATE": {
                    SimpleDateFormat format = new SimpleDateFormat(line.getDateMask());
                    fieldVaule = format.format(now);
                    break;
                }
                case "UUID": {
                    fieldVaule = UUID.randomUUID().toString();
                    break;
                }
            }
            result.append(fieldVaule);
        });
        return this.translateData(result.toString(), variables);
    }

    private String getSeq(CodeRulesLine line) {
        int seqLength;
        boolean resetFlag = false;
        Date now = new Date();
        for (ICodeRuleResetStrategy strategy : this.strategyList) {
            resetFlag = strategy.isResetSequence(line.getResetFrequency(), line.getResetDate(), now);
            if (!resetFlag) continue;
            this.ruleCache.reset(line);
            break;
        }
        Long incrSeq = this.ruleCache.incr(line);
        Long incrNum = incrSeq - line.getStartValue();
        Long stepNumber = line.getStepNumber();
        if (stepNumber == null || stepNumber <= 0L) {
            stepNumber = CodeRuleConstants.INCR_NUMBER;
        }
        if (!resetFlag && incrNum > 0L && incrNum % stepNumber == 0L) {
            if (SecurityTokenInterceptor.LOCAL_SECURITY_KEY.get() != null) {
                TokenUtils.generateAndSetToken((String)((String)SecurityTokenInterceptor.LOCAL_SECURITY_KEY.get()), (BaseDTO)line);
            }
            line.setCurrentValue(Long.valueOf(incrSeq + stepNumber));
            this.codeRulesLineService.updateRecord(line);
            this.ruleCache.updateLine(line);
        }
        if ((long)(seqLength = String.valueOf(incrSeq).length()) > line.getSeqLength()) {
            this.ruleCache.decr(line);
            this.logger.error("Failed to generate the encoding, the sequence is longer than the length");
            throw new RuntimeException((Throwable)new CodeRuleException("Failed to generate the encoding, the sequence is longer than the length", "ruleCode:" + line.getRuleCode()));
        }
        String format = "%0" + line.getSeqLength() + "d";
        return String.format(format, incrSeq);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String translateData(String content, Map data) throws CodeRuleException {
        if (content == null) {
            return "";
        }
        try (StringWriter out = new StringWriter();){
            Configuration config = FreemarkerUtil.getConfiguration();
            Template template = new Template(null, content, config);
            template.process((Object)data, (Writer)out);
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            throw new CodeRuleException(e.getMessage(), "Failed to generate the encoding, process varible fail");
        }
    }

    public void contextInitialized(ApplicationContext applicationContext) {
        this.strategyList = new ArrayList(applicationContext.getBeansOfType(ICodeRuleResetStrategy.class).values());
    }
}

