/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.code.rule.service.impl;

import com.hand.hap.cache.impl.SysCodeRuleCache;
import com.hand.hap.code.rule.dto.CodeRulesHeader;
import com.hand.hap.code.rule.dto.CodeRulesLine;
import com.hand.hap.code.rule.mapper.CodeRulesHeaderMapper;
import com.hand.hap.code.rule.mapper.CodeRulesLineMapper;
import com.hand.hap.code.rule.service.ICodeRulesHeaderService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CodeRulesHeaderServiceImpl
extends BaseServiceImpl<CodeRulesHeader>
implements ICodeRulesHeaderService {
    @Autowired
    private SysCodeRuleCache ruleCache;
    @Autowired
    private CodeRulesHeaderMapper headerMapper;
    @Autowired
    private CodeRulesLineMapper lineMapper;

    public CodeRulesHeader updateCodeRule(CodeRulesHeader record) {
        this.headerMapper.updateByPrimaryKey((Object)record);
        boolean deleteSeq = false;
        if (record.getLines() != null) {
            deleteSeq = this.processLines(record);
        }
        this.ruleCache.remove(record.getRuleCode());
        if (deleteSeq) {
            this.ruleCache.removeSeq(record.getRuleCode());
        }
        if ("Y".equalsIgnoreCase(record.getEnableFlag())) {
            this.ruleCache.reload(record);
        }
        return record;
    }

    public CodeRulesHeader createCodeRule(CodeRulesHeader record) {
        this.headerMapper.insertSelective((Object)record);
        if (record.getLines() != null) {
            this.processLines(record);
        }
        if ("Y".equalsIgnoreCase(record.getEnableFlag())) {
            this.ruleCache.reload(record);
        }
        return record;
    }

    public int deleteByPrimaryKey(CodeRulesHeader record) {
        CodeRulesLine line = new CodeRulesLine();
        line.setHeaderId(record.getHeaderId());
        this.lineMapper.deleteByHeaderId(line);
        int result = this.headerMapper.deleteByPrimaryKey((Object)record);
        this.ruleCache.remove(record.getRuleCode());
        this.ruleCache.removeSeq(record.getRuleCode());
        return result;
    }

    public List<CodeRulesHeader> batchUpdate(IRequest request, List<CodeRulesHeader> list) {
        for (CodeRulesHeader header : list) {
            if (header.getHeaderId() == null) {
                ((ICodeRulesHeaderService)this.self()).createCodeRule(header);
                continue;
            }
            ((ICodeRulesHeaderService)this.self()).updateCodeRule(header);
        }
        return list;
    }

    private boolean processLines(CodeRulesHeader header) {
        boolean updateSeq = false;
        for (CodeRulesLine line : header.getLines()) {
            if (line.getHeaderId() == null) {
                line.setHeaderId(header.getHeaderId());
                this.lineMapper.insertSelective((Object)line);
                continue;
            }
            int count = this.lineMapper.updateByPrimaryKey((Object)line);
            this.checkOvn(count, (Object)line);
            if (!"SEQUENCE".equalsIgnoreCase(line.getFiledType())) continue;
            updateSeq = true;
        }
        return updateSeq;
    }
}

