/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.dto.RoleResourceItem;
import com.hand.hap.function.mapper.RoleResourceItemMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleResourceItemCache
extends HashStringRedisCache<Long[]> {
    private String roleResourceItemQueryAllSqlId = RoleResourceItemMapper.class.getName() + ".selectForCache";
    private String roleResourceItemQuerySqlId = RoleResourceItemMapper.class.getName() + ".selectResourceItemsByRole";
    private final Logger logger = LoggerFactory.getLogger(RoleResourceItemCache.class);

    public RoleResourceItemCache() {
        this.setLoadOnStartUp(true);
        this.setType(Long[].class);
    }

    public Long[] getValue(String key) {
        return (Long[])super.getValue(key);
    }

    public void setValue(String key, Long[] values) {
        super.setValue(key, (Object)values);
    }

    protected void initLoad() {
        block15: {
            HashMap<String, List> roleResourceItems = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.roleResourceItemQueryAllSqlId, resultContext -> {
                    RoleResourceItem value = (RoleResourceItem)resultContext.getResultObject();
                    String roleId = value.getRoleId().toString();
                    ArrayList<Long> resourceItems = (ArrayList<Long>)roleResourceItems.get(roleId);
                    if (resourceItems == null) {
                        resourceItems = new ArrayList<Long>();
                        roleResourceItems.put(roleId, resourceItems);
                    }
                    resourceItems.add(value.getResourceItemId());
                });
                roleResourceItems.forEach((k, v) -> this.setValue(k, v.toArray(new Long[v.size()])));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all role resource item cache");
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init role resource item cache exception: ", (Throwable)e);
            }
        }
    }

    public void load(String roleId) {
        block14: {
            HashMap<String, List> roleResourceItems = new HashMap<String, List>();
            super.remove(roleId);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.roleResourceItemQuerySqlId, (Object)Long.parseLong(roleId), resultContext -> {
                    RoleResourceItem value = (RoleResourceItem)resultContext.getResultObject();
                    ArrayList<Long> sets = (ArrayList<Long>)roleResourceItems.get(roleId);
                    if (sets == null) {
                        sets = new ArrayList<Long>();
                        roleResourceItems.put(roleId, sets);
                    }
                    sets.add(value.getResourceItemId());
                });
                roleResourceItems.forEach((k, v) -> this.setValue(k, v.toArray(new Long[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load role resource item cache exception: ", (Throwable)e);
            }
        }
    }
}

