/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.dto.MessageEmailConfig;
import com.hand.hap.mail.dto.MessageEmailProperty;
import com.hand.hap.mail.dto.MessageEmailWhiteList;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.mapper.MessageEmailConfigMapper;
import com.hand.hap.mail.mapper.MessageEmailPropertyMapper;
import com.hand.hap.mail.mapper.MessageEmailWhiteListMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageEmailConfigCache
extends HashStringRedisCache<MessageEmailConfig> {
    private final Logger logger = LoggerFactory.getLogger(MessageEmailConfigCache.class);
    private String messageEmailConfigQueryAllSqlId = MessageEmailConfigMapper.class.getName() + ".selectAll";
    private String messageEmailAccountQueryAllSqlId = MessageEmailAccountMapper.class.getName() + ".selectAll";
    private String messageEmailWhiteListQueryAllSqlId = MessageEmailWhiteListMapper.class.getName() + ".selectAll";
    private String messageEmailPropertyQueryAllSqlId = MessageEmailPropertyMapper.class.getName() + ".selectAll";
    private String messageEmailAccountQuerySqlId = MessageEmailAccountMapper.class.getName() + ".selectByConfigId";
    private String messageEmailWhiteListQuerySqlId = MessageEmailWhiteListMapper.class.getName() + ".selectByConfigId";
    private String messageEmailPropertyQuerySqlId = MessageEmailPropertyMapper.class.getName() + ".selectByConfigId";

    public MessageEmailConfigCache() {
        this.setLoadOnStartUp(true);
        this.setType(MessageEmailConfig.class);
    }

    public MessageEmailConfig getValue(String key) {
        return (MessageEmailConfig)super.getValue(key);
    }

    public void setValue(String key, MessageEmailConfig value) {
        super.setValue(key, (Object)value);
    }

    protected void initLoad() {
        block15: {
            HashMap<Long, MessageEmailConfig> messageEmailConfigMap = new HashMap<Long, MessageEmailConfig>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.messageEmailConfigQueryAllSqlId, resultContext -> {
                    MessageEmailConfig messageEmailConfig = (MessageEmailConfig)resultContext.getResultObject();
                    messageEmailConfigMap.put(messageEmailConfig.getConfigId(), messageEmailConfig);
                });
                sqlSession.select(this.messageEmailAccountQueryAllSqlId, resultContext -> {
                    MessageEmailAccount account = (MessageEmailAccount)resultContext.getResultObject();
                    MessageEmailConfig config = (MessageEmailConfig)messageEmailConfigMap.get(account.getConfigId());
                    if (config != null) {
                        ArrayList<MessageEmailAccount> accounts = config.getEmailAccounts();
                        if (accounts == null) {
                            accounts = new ArrayList<MessageEmailAccount>();
                            config.setEmailAccounts(accounts);
                        }
                        accounts.add(account);
                    }
                });
                sqlSession.select(this.messageEmailWhiteListQueryAllSqlId, resultContext -> {
                    MessageEmailWhiteList whiteList = (MessageEmailWhiteList)resultContext.getResultObject();
                    MessageEmailConfig config = (MessageEmailConfig)messageEmailConfigMap.get(whiteList.getConfigId());
                    if (config != null) {
                        ArrayList<MessageEmailWhiteList> whiteLists = config.getWhiteLists();
                        if (whiteLists == null) {
                            whiteLists = new ArrayList<MessageEmailWhiteList>();
                            config.setWhiteLists(whiteLists);
                        }
                        whiteLists.add(whiteList);
                    }
                });
                sqlSession.select(this.messageEmailPropertyQueryAllSqlId, resultContext -> {
                    MessageEmailProperty property = (MessageEmailProperty)resultContext.getResultObject();
                    MessageEmailConfig config = (MessageEmailConfig)messageEmailConfigMap.get(property.getConfigId());
                    if (config != null) {
                        ArrayList<MessageEmailProperty> propertyLists = config.getPropertyLists();
                        if (propertyLists == null) {
                            propertyLists = new ArrayList<MessageEmailProperty>();
                            config.setPropertyLists(propertyLists);
                        }
                        propertyLists.add(property);
                    }
                });
                messageEmailConfigMap.forEach((k, v) -> this.setValue(k.toString(), v));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all message email config cache");
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init message email config cache exception: ", e);
            }
        }
    }

    public void reload(Long configId) {
        block14: {
            super.remove(configId.toString());
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                MessageEmailConfig config = (MessageEmailConfig)sqlSession.selectOne(MessageEmailConfigMapper.class.getName() + ".selectByPrimaryKey", (Object)configId);
                List accounts = sqlSession.selectList(this.messageEmailAccountQuerySqlId, (Object)configId);
                List whiteLists = sqlSession.selectList(this.messageEmailWhiteListQuerySqlId, (Object)configId);
                List properties = sqlSession.selectList(this.messageEmailPropertyQuerySqlId, (Object)configId);
                config.setEmailAccounts(accounts);
                config.setWhiteLists(whiteLists);
                config.setPropertyLists(properties);
                this.setValue(config.getConfigId().toString(), config);
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load message email config cache exception: ", e);
            }
        }
    }

    public void remove(Long configId) {
        super.remove(configId.toString());
    }
}

