/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.system.dto.Hotkey;
import com.hand.hap.system.mapper.HotkeyMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HotkeyCache
extends HashStringRedisCache<Hotkey[]> {
    private Logger logger = LoggerFactory.getLogger(HotkeyCache.class);
    private String selectAll = HotkeyMapper.class.getName() + ".queryAll";
    private String selectByKey = HotkeyMapper.class.getName() + ".select";
    @Autowired
    private ILanguageProvider iLanguageProvider;

    public HotkeyCache() {
        this.setLoadOnStartUp(true);
        this.setType(Hotkey[].class);
    }

    public Hotkey[] getValue(String key) {
        return (Hotkey[])super.getValue(key);
    }

    public void setValue(String key, Hotkey[] values) {
        super.setValue(key, (Object)values);
    }

    public void load(String key) {
        block14: {
            super.remove(key);
            HashMap<String, List> hotkeys = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.selectByKey, (Object)this.setHotkey(key), resultContext -> {
                    Hotkey value = (Hotkey)resultContext.getResultObject();
                    ArrayList<Hotkey> sets = (ArrayList<Hotkey>)hotkeys.get(key);
                    if (sets == null) {
                        sets = new ArrayList<Hotkey>();
                        hotkeys.put(key, sets);
                    }
                    sets.add(value);
                });
                hotkeys.forEach((k, v) -> this.setValue(k, v.toArray(new Hotkey[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load hotkey cache exception: ", (Throwable)e);
            }
        }
    }

    protected void initLoad() {
        block15: {
            HashMap<String, List> hotkeys = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.selectAll, resultContext -> {
                    Hotkey value = (Hotkey)resultContext.getResultObject();
                    String key = value.getHotkeyLevel() + "_" + value.getHotkeyLevelId().toString();
                    ArrayList<Hotkey> items = (ArrayList<Hotkey>)hotkeys.get(key);
                    if (items == null) {
                        items = new ArrayList<Hotkey>();
                        hotkeys.put(key, items);
                    }
                    items.add(value);
                });
                hotkeys.forEach((k, v) -> this.setValue(k, v.toArray(new Hotkey[v.size()])));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all hotkey cache");
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init hotkey cache exception: ", (Throwable)e);
            }
        }
    }

    private Hotkey setHotkey(String key) {
        Hotkey hotkey = new Hotkey();
        if (key != null && key.indexOf("_") != -1) {
            hotkey.setHotkeyLevelId(Long.valueOf(Long.parseLong(StringUtils.substringAfterLast((String)key, (String)"_"))));
            hotkey.setHotkeyLevel(StringUtils.substringBeforeLast((String)key, (String)"_"));
        }
        return hotkey;
    }
}

