/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.api.application.dto.ApiAccessLimit;
import com.hand.hap.api.application.mapper.ApiAccessLimitMapper;
import com.hand.hap.cache.impl.HashStringRedisCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAccessLimitCache
extends HashStringRedisCache<Map<String, ApiAccessLimit>> {
    private String selectAccessLimit = ApiAccessLimitMapper.class.getName() + ".selectAll";
    private final Logger logger = LoggerFactory.getLogger(ApiAccessLimitCache.class);

    public ApiAccessLimitCache() {
        this.setLoadOnStartUp(true);
        this.setType(ApiAccessLimit.class);
    }

    public Map<String, ApiAccessLimit> getValue(String clientId, String serverCode) {
        String key = clientId + "_" + serverCode;
        return (Map)super.getValue(key);
    }

    public void setValue(String key, Map<String, ApiAccessLimit> value) {
        super.setValue(key, value);
    }

    public void setValue(ApiAccessLimit value) {
        Map<String, ApiAccessLimit> apiAccessLimitMap = new HashMap();
        apiAccessLimitMap = this.getValue(value.getClientId(), value.getServerCode());
        if (null == apiAccessLimitMap) {
            apiAccessLimitMap = new HashMap();
        }
        String code = value.getInterfaceCode();
        apiAccessLimitMap.put(code, value);
        String key = value.getClientId() + "_" + value.getServerCode();
        super.setValue(key, apiAccessLimitMap);
    }

    protected void initLoad() {
        block14: {
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                List apiAccessLimits = sqlSession.selectList(this.selectAccessLimit);
                HashMap<String, List> groupMap = new HashMap<String, List>();
                Map<String, List<ApiAccessLimit>> apiAccessLimitMap = apiAccessLimits.stream().collect(Collectors.groupingBy(ApiAccessLimit::getClientId));
                apiAccessLimitMap.forEach((key, value) -> {
                    Map<String, List<ApiAccessLimit>> serverCodeMap = value.stream().collect(Collectors.groupingBy(ApiAccessLimit::getServerCode));
                    serverCodeMap.forEach((k, v) -> {
                        String keys = key + "_" + k;
                        groupMap.put(keys, (List)v);
                    });
                });
                groupMap.forEach((key, value) -> {
                    HashMap resultMap = new HashMap();
                    value.forEach(apiAccessLimit -> resultMap.put(apiAccessLimit.getInterfaceCode(), apiAccessLimit));
                    this.setValue(key, resultMap);
                });
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("init apiAccessLimit cache exception: ", (Throwable)e);
            }
        }
    }

    protected Map<String, ApiAccessLimit> stringToObject(String value) {
        try {
            return (Map)this.getObjectMapper().readValue(value, this.getObjectMapper().getTypeFactory().constructParametricType(HashMap.class, new Class[]{String.class, ApiAccessLimit.class}));
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("invalid value: " + value);
            }
            throw new RuntimeException(e);
        }
    }
}

