/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.service.impl;

import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.exception.CategorySourceTypeRepeatException;
import com.hand.hap.attachment.exception.StoragePathNotExsitException;
import com.hand.hap.attachment.mapper.AttachCategoryMapper;
import com.hand.hap.attachment.service.IAttachCategoryService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.util.FormatUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AttachCategoryServiceImpl
implements IAttachCategoryService {
    public static final String CATEGORY_PATH_NOT_CORRECT = "category_path_not_correct";
    @Autowired
    private AttachCategoryMapper categoryMapper;

    public AttachCategory insert(IRequest requestContext, @StdWho AttachCategory category) {
        AttachCategory parent;
        if (StringUtils.isBlank((String)category.getStatus())) {
            category.setStatus("1");
        }
        if ((parent = (AttachCategory)this.categoryMapper.selectByPrimaryKey((Object)category.getParentCategoryId())) != null && "1".equals(parent.getLeafFlag())) {
            parent.setLeafFlag("0");
            this.categoryMapper.updateByPrimaryKeySelective((Object)parent);
        }
        this.categoryMapper.insertSelective((Object)category);
        category.setPath(String.valueOf(category.getCategoryId()));
        if (category.getParentCategoryId() != null) {
            AttachCategory p1 = new AttachCategory();
            p1.setCategoryId(category.getParentCategoryId());
            p1 = (AttachCategory)this.categoryMapper.selectByPrimaryKey((Object)p1);
            if (p1 != null) {
                category.setPath(p1.getPath() + "." + category.getCategoryId());
            }
        }
        this.categoryMapper.updateByPrimaryKeySelective((Object)category);
        return category;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public AttachCategory selectAttachByCode(IRequest requestContext, String sourceCode) {
        if (StringUtils.isBlank((String)sourceCode)) {
            return null;
        }
        AttachCategory params = new AttachCategory();
        params.setSourceType(sourceCode);
        params.setStatus("1");
        return this.categoryMapper.selectCategory(params);
    }

    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public String selectPathByCode(IRequest requestContext, String sourceType) throws StoragePathNotExsitException {
        AttachCategory params = new AttachCategory();
        params.setSourceType(sourceType);
        AttachCategory category = this.categoryMapper.selectCategory(params);
        if (category == null || category.getCategoryPath().length() <= 0) {
            throw new StoragePathNotExsitException();
        }
        return category.getCategoryPath();
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<AttachCategory> selectCategories(AttachCategory category) {
        return this.categoryMapper.select((Object)category);
    }

    public List<AttachCategory> batchUpdate(IRequest requestCtx, @StdWho List<AttachCategory> categories) {
        for (AttachCategory category : categories) {
            if (category.getCategoryId() == null) {
                ((IAttachCategoryService)this.self()).insert(requestCtx, category);
                continue;
            }
            this.categoryMapper.updateByPrimaryKeySelective((Object)category);
        }
        return categories;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public AttachCategory selectByPrimaryKey(IRequest requestContext, Long categoryId) {
        return (AttachCategory)this.categoryMapper.selectByPrimaryKey((Object)categoryId);
    }

    public boolean remove(AttachCategory category) {
        if ((category = (AttachCategory)this.categoryMapper.selectByPrimaryKey((Object)category.getCategoryId())) == null || "0".equals(category.getLeafFlag())) {
            return false;
        }
        category.setStatus("2");
        this.categoryMapper.updateByPrimaryKeySelective((Object)category);
        return true;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<AttachCategory> selectCategories(IRequest requestContext, AttachCategory category) {
        List categories = this.categoryMapper.select((Object)category);
        categories.forEach(c -> {
            String fileSize = FormatUtil.formatFileSize((Long)c.getAllowedFileSize());
            if (!"0".equalsIgnoreCase(fileSize)) {
                c.setAllowedFileSizeDesc(fileSize);
            }
        });
        return categories;
    }

    public void validateType(List<AttachCategory> categories) throws CategorySourceTypeRepeatException {
        for (AttachCategory category : categories) {
            if (category.getCategoryId() != null || this.categoryMapper.countSourceType(category.getSourceType()) <= 0) continue;
            throw new CategorySourceTypeRepeatException(category.getSourceType());
        }
    }

    public List<AttachCategory> selectCategoryBreadcrumbList(IRequest requestContext, Long categoryId) {
        AttachCategory a1 = new AttachCategory();
        a1.setCategoryId(categoryId);
        AttachCategory current = (AttachCategory)this.categoryMapper.selectByPrimaryKey((Object)a1);
        String path = "";
        if (current != null) {
            path = StringUtils.trimToEmpty((String)current.getPath());
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(-1L);
        String[] paths = StringUtils.split((String)path, (String)".");
        for (int i = 0; i < paths.length; ++i) {
            idList.add(Long.parseLong(paths[i]));
        }
        List cates = this.categoryMapper.selectAllParentCategory(idList);
        if (cates != null && !cates.isEmpty()) {
            cates.sort((a, b) -> {
                if (a.getCategoryId().equals(b.getParentCategoryId())) {
                    return -1;
                }
                if (a.getParentCategoryId().equals(b.getCategoryId())) {
                    return 1;
                }
                return 0;
            });
            cates.forEach(a -> a.setCategoryName(StringUtils.abbreviate((String)a.getCategoryName(), (int)15)));
        }
        return cates;
    }

    public List<AttachCategory> queryTree(IRequest requestContext, AttachCategory category) {
        List list = this.categoryMapper.queryTree(category);
        for (AttachCategory attachCategory : list) {
            if (!Objects.equals(attachCategory.getParentCategoryId(), -1L)) continue;
            attachCategory.setParentCategoryId(null);
        }
        return list;
    }
}

