/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.controllers;

import com.hand.hap.attachment.FileInfo;
import com.hand.hap.attachment.Uploader;
import com.hand.hap.attachment.UploaderFactory;
import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.dto.Attachment;
import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.exception.AttachmentException;
import com.hand.hap.attachment.exception.FileReadIOException;
import com.hand.hap.attachment.exception.UniqueFileMutiException;
import com.hand.hap.attachment.service.IAttachCategoryService;
import com.hand.hap.attachment.service.ISysFileService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.core.util.FormatUtil;
import com.hand.hap.core.util.UploadUtil;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.ResponseData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttachmentController
extends BaseController {
    private static final String MESSAGE_NAME = "message";
    private static final String MESG_UNIQUE = "Unique";
    private static final String MESG_SUCCESS = "success";
    private static final String INFO_NAME = "info";
    private static final String TYPEORKEY_EMPTY = "TYPEORKEY_EMPTY";
    private static final String TYPE_ERROR = "SOURCETYPE_ERROR";
    private static final String DATABASE_ERROR = "DATABASE_ERROR";
    private static final String IMAGE_MIME_PREFIX = "image";
    private static final String FILE_NAME = "file";
    private static final Integer BUFFER_SIZE = 1024;
    private static final Float COMPRESS_SIZE = Float.valueOf(40.0f);
    private static final Float BYTE_TO_KB = Float.valueOf(1024.0f);
    private static final String ENC = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(AttachmentController.class);
    @Autowired
    private IAttachCategoryService categoryService;
    @Autowired
    private ISysFileService fileService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/sys/attach/manage"}, method={RequestMethod.GET})
    public ModelAndView manager(HttpServletRequest request, String sourceType, String sourceKey) {
        request.setAttribute("sourceType", (Object)sourceType);
        request.setAttribute("sourceKey", (Object)sourceKey);
        IRequest requestContext = this.createRequestContext(request);
        AttachCategory category = this.categoryService.selectAttachByCode(requestContext, sourceType);
        if (category != null) {
            request.setAttribute("files", (Object)this.fileService.selectFilesByTypeAndKey(requestContext, sourceType, sourceKey));
            request.setAttribute(MESSAGE_NAME, (Object)MESG_SUCCESS);
        }
        return new ModelAndView(this.getViewPath() + "/attach/sys_attach_manage");
    }

    @RequestMapping(value={"/sys/attach/upload"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    public ResponseData upload(HttpServletRequest request, Locale locale, String contextPath) throws Exception {
        Uploader uploader = UploaderFactory.getMutiUploader();
        uploader.init(request);
        String status = uploader.getStatus();
        if ("NOT_FILE_ERROR".equals(status)) {
            throw new AttachmentException("error.upload.not.file.form", "error.upload.not.file.form", new Object[0]);
        }
        if ("LIMIT_SIZE_MAX_ERROR".equals(status)) {
            throw new AttachmentException("error.upload.total.size.limit.exceeded", "error.upload.total.size.limit.exceeded", new Object[0]);
        }
        if ("LIMIT_UPLOAD_NUM_ERROR".equals(status)) {
            throw new AttachmentException("error.upload.total.num.limit.exceeded", "error.upload.total.num.limit.exceeded", new Object[0]);
        }
        if ("UPLOAD_ERROR".equals(status)) {
            throw new AttachmentException("error.upload.unknown", "error.upload.unknown", new Object[0]);
        }
        String sourceType = uploader.getParams("sourceType");
        String sourceKey = uploader.getParams("sourceKey");
        ResponseData response = new ResponseData();
        response.setMessage(this.messageSource.getMessage("hap.upload_success", null, locale));
        if (StringUtils.isBlank((String)sourceType)) {
            throw new AttachmentException("msg.warning.upload.sourcetype.empty", "msg.warning.upload.sourcetype.empty", new Object[0]);
        }
        IRequest requestContext = this.createRequestContext(request);
        AttachCategory category = this.categoryService.selectAttachByCode(requestContext, sourceType);
        if (category == null) {
            throw new AttachmentException("msg.warning.upload.folder.notfound", "msg.warning.upload.folder.notfound", (Object[])new String[]{sourceType});
        }
        UploadUtil.initUploaderParams((Uploader)uploader, (AttachCategory)category);
        List fileInfoList = uploader.upload();
        status = uploader.getStatus();
        if ("FILE_PROCESS_ERROR".equals(status)) {
            throw new AttachmentException("error.upload.file.process", "error.upload.file.process", new Object[0]);
        }
        Attachment attach = UploadUtil.genAttachment((AttachCategory)category, (String)sourceKey, (Long)requestContext.getUserId(), (Long)requestContext.getUserId());
        ArrayList<SysFile> sysFileList = new ArrayList<SysFile>();
        for (FileInfo fileInfo : fileInfoList) {
            try {
                SysFile sysFile = UploadUtil.genSysFile((FileInfo)fileInfo, (Long)requestContext.getUserId(), (Long)requestContext.getUserId());
                if ("Y".equals(category.getIsUnique())) {
                    sysFile = this.fileService.updateOrInsertFile(requestContext, attach, sysFile);
                } else {
                    this.fileService.insertFileAndAttach(requestContext, attach, sysFile);
                }
                sysFile.setFilePath(null);
                sysFile.setFileSizeDesc(FormatUtil.formatFileSize((Long)sysFile.getFileSize()));
                TokenUtils.generateAndSetToken((String)TokenUtils.getSecurityKey((HttpSession)request.getSession(false)), (BaseDTO)sysFile);
                sysFileList.add(sysFile);
            }
            catch (UniqueFileMutiException ex) {
                response.setSuccess(false);
                response.setMessage(this.messageSource.getMessage("hap.mesg_unique", null, locale));
                break;
            }
            catch (Exception e) {
                File file;
                if (logger.isErrorEnabled()) {
                    logger.error("database error", (Throwable)e);
                }
                if ((file = fileInfo.getFile()).exists()) {
                    file.delete();
                }
                response.setSuccess(false);
                break;
            }
        }
        response.setRows(sysFileList);
        return response;
    }

    @RequestMapping(value={"/sys/attach/remove"})
    public Map<String, Object> remove(HttpServletRequest request, String fileId, String token) throws TokenException {
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        IRequest requestContext = this.createRequestContext(request);
        SysFile file = new SysFile();
        file.setFileId(Long.valueOf(fileId));
        file.set_token(token);
        TokenUtils.checkToken((HttpSession)request.getSession(false), (BaseDTO)file);
        this.fileService.delete(requestContext, file);
        response.put(MESSAGE_NAME, MESG_SUCCESS);
        return response;
    }

    @RequestMapping(value={"/sys/attach/file/detail", "/sys/attach/file/download"})
    public void detail(HttpServletRequest request, HttpServletResponse response, String fileId, String token) throws Exception {
        IRequest requestContext = this.createRequestContext(request);
        SysFile sysFile = this.fileService.selectByPrimaryKey(requestContext, Long.valueOf(fileId));
        sysFile.set_token(token);
        TokenUtils.checkToken((HttpSession)request.getSession(false), (BaseDTO)sysFile);
        File file = new File(sysFile.getFilePath());
        if (file.exists()) {
            response.addHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(sysFile.getFileName(), ENC) + "\"");
            response.setContentType(sysFile.getFileType() + ";charset=" + ENC);
            response.setHeader("Accept-Ranges", "bytes");
            int fileLength = (int)file.length();
            response.setContentLength(fileLength);
            if (fileLength > 0) {
                this.writeFileToResp(response, file);
            }
        } else {
            throw new AttachmentException("msg.warning.download.file.error", "msg.warning.download.file.error", new Object[0]);
        }
    }

    @RequestMapping(value={"/sys/attach/file/view"})
    public void view(HttpServletRequest request, HttpServletResponse response, String fileId, String compress) throws Exception {
        block16: {
            IRequest requestContext = this.createRequestContext(request);
            SysFile sysFile = this.fileService.selectByPrimaryKey(requestContext, Long.valueOf(fileId));
            try {
                File file = new File(sysFile.getFilePath());
                if (file.exists()) {
                    response.setHeader("cache-control", "must-revalidate");
                    response.setHeader("pragma", "public");
                    response.setHeader("Content-Type", sysFile.getFileType());
                    response.setHeader("Accept-Ranges", "bytes");
                    response.setHeader("Content-disposition", "attachment;" + this.processFileName(request, sysFile.getFileName()));
                    int fileLength = (int)file.length();
                    response.setContentLength(fileLength);
                    if (fileLength <= 0) break block16;
                    if (StringUtils.isNotBlank((String)compress) && "Y".equals(compress)) {
                        try (ServletOutputStream os = response.getOutputStream();){
                            Thumbnails.of((File[])new File[]{file}).scale((double)this.getCompressPercent((long)fileLength)).toOutputStream((OutputStream)os);
                            os.flush();
                            break block16;
                        }
                    }
                    this.writeFileToResp(response, file);
                    break block16;
                }
                throw new AttachmentException("msg.warning.download.file.error", "msg.warning.download.file.error", new Object[0]);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new FileReadIOException();
            }
        }
    }

    private String processFileName(HttpServletRequest request, String filename) throws UnsupportedEncodingException {
        String userAgent = request.getHeader("User-Agent");
        String new_filename = URLEncoder.encode(filename, "UTF8");
        String rtn = "filename=\"" + new_filename + "\"";
        if (userAgent != null) {
            if ((userAgent = userAgent.toLowerCase()).indexOf("msie") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes("GB2312"), "ISO-8859-1") + "\"";
            } else if (userAgent.indexOf("safari") != -1 || userAgent.indexOf("applewebkit") != -1) {
                rtn = "filename=\"" + new String(filename.getBytes(ENC), "ISO8859-1") + "\"";
            } else if (userAgent.indexOf("opera") != -1 || userAgent.indexOf("mozilla") != -1) {
                rtn = "filename*=UTF-8''" + new_filename;
            }
        }
        return rtn;
    }

    private void writeFileToResp(HttpServletResponse response, File file) throws Exception {
        byte[] buf = new byte[BUFFER_SIZE.intValue()];
        try (FileInputStream inStream = new FileInputStream(file);
             ServletOutputStream outputStream = response.getOutputStream();){
            int readLength;
            while ((readLength = ((InputStream)inStream).read(buf)) != -1) {
                outputStream.write(buf, 0, readLength);
            }
            outputStream.flush();
        }
    }

    private float getCompressPercent(long len) {
        return (float)len / (BYTE_TO_KB.floatValue() * COMPRESS_SIZE.floatValue());
    }
}

