/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.controllers;

import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.exception.CategorySourceTypeRepeatException;
import com.hand.hap.attachment.service.IAttachCategoryService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttachCategoryController
extends BaseController {
    @Autowired
    private IAttachCategoryService categoryService;

    @RequestMapping(value={"/sys/attachment/category/query"})
    public ResponseData query(HttpServletRequest request, AttachCategory category) {
        if (category.getParentCategoryId() == null) {
            category.setParentCategoryId(AttachCategory.NO_PARENT);
        }
        category.setSortname("categoryName");
        category.setSortorder("ASC");
        return new ResponseData(this.categoryService.selectCategories(this.createRequestContext(request), category));
    }

    @RequestMapping(value={"/sys/attachment/category/submit"}, method={RequestMethod.POST})
    public ResponseData submitCategory(HttpServletRequest request, @RequestBody List<AttachCategory> categories, BindingResult result) throws CategorySourceTypeRepeatException {
        this.getValidator().validate(categories, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        this.categoryService.validateType(categories);
        return new ResponseData(this.categoryService.batchUpdate(this.createRequestContext(request), categories));
    }

    @RequestMapping(value={"/attach/sys_attach_category_manage.html"})
    public ModelAndView attachmentCategoryList(HttpServletRequest request, @RequestParam(required=false) String parentCategoryId) {
        ModelAndView view = new ModelAndView(this.getViewPath() + "/attach/sys_attach_category_manage");
        if (parentCategoryId != null) {
            List cates = this.categoryService.selectCategoryBreadcrumbList(this.createRequestContext(request), Long.valueOf(parentCategoryId));
            view.addObject("breadCrumb", (Object)cates);
        }
        return view;
    }

    @RequestMapping(value={"/sys/attachment/category/queryTree"})
    @ResponseBody
    public List<AttachCategory> queryTree(HttpServletRequest request, AttachCategory category) {
        IRequest requestCtx = this.createRequestContext(request);
        return this.categoryService.queryTree(requestCtx, category);
    }
}

