/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.logs.service.impl;

import com.google.common.base.Throwables;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.api.logs.dto.ApiInvokeRecord;
import com.hand.hap.api.logs.dto.ApiResponseData;
import com.hand.hap.api.logs.info.ApiInvokeInfo;
import com.hand.hap.core.components.UserLoginInfoCollection;
import com.hand.hap.core.util.ExceptionUtil;
import com.hand.hap.intergration.controllers.HapInvokeRequestBodyAdvice;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.message.IMessagePublisher;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiRequestExecutionAdvice
implements MethodInterceptor {
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    private IApiServerService serverService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Long startTime = System.currentTimeMillis();
        ApiResponseData apiResponseData = new ApiResponseData();
        Exception throwable = null;
        ApiInvokeRecord apiInvokeRecord = new ApiInvokeRecord();
        ApiInvokeInfo.API_INVOKE_RECORD.set(apiInvokeRecord);
        ApiServer server = null;
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            OAuth2Authentication authentication = (OAuth2Authentication)SecurityContextHolder.getContext().getAuthentication();
            String cilentId = authentication.getOAuth2Request().getClientId();
            apiInvokeRecord.setInvokeId(UUID.randomUUID().toString());
            apiInvokeRecord.setRequestTime(new Date());
            apiInvokeRecord.setClientId(cilentId);
            apiInvokeRecord.setClientId(cilentId);
            apiInvokeRecord.setApiUrl(StringUtils.substringAfter((String)request.getRequestURI(), (String)request.getContextPath()));
            apiInvokeRecord.setRequestMethod(request.getMethod());
            apiInvokeRecord.setIp(UserLoginInfoCollection.getIpAddress((HttpServletRequest)request));
            apiInvokeRecord.setUserAgent(request.getHeader("User-Agent"));
            apiInvokeRecord.setReferer(StringUtils.abbreviate((String)request.getHeader("Referer"), (int)240));
            server = this.getServer(invocation);
            apiResponseData = (ApiResponseData)invocation.proceed();
            apiResponseData.setCode("SUCCESS");
        }
        catch (Exception e) {
            throwable = e;
            apiResponseData.setSuccess(false);
            apiResponseData.setMessage(Throwables.getRootCause((Throwable)throwable).getMessage().replaceAll("\"", ""));
            if (e instanceof HapApiException) {
                apiResponseData.setCode(((HapApiException)e).getCode());
            } else {
                apiResponseData.setCode("API_SYSTEM_EXCEPTION");
            }
            apiInvokeRecord.getApiInvokeRecordDetails().setApiRequestBodyParameter(HapInvokeRequestBodyAdvice.getAndRemoveBody());
            apiInvokeRecord.getApiInvokeRecordDetails().setApiResponseContent(JSONObject.fromObject((Object)apiResponseData).toString());
        }
        finally {
            apiResponseData.setRequestId(apiInvokeRecord.getInvokeId());
            apiInvokeRecord.setResponseStatus("success");
            if (server != null && "Y".equals(server.getApiInterface().getInvokeRecordDetails())) {
                apiInvokeRecord.getApiInvokeRecordDetails().setApiRequestBodyParameter(HapInvokeRequestBodyAdvice.getAndRemoveBody());
                apiInvokeRecord.getApiInvokeRecordDetails().setApiResponseContent(JSONObject.fromObject((Object)apiResponseData).toString());
            }
            apiInvokeRecord.setApiResponseTime(Long.valueOf(System.currentTimeMillis() - startTime));
            ApiRequestExecutionAdvice.processExceptionInfo((ApiInvokeRecord)apiInvokeRecord, (Throwable)throwable);
            this.messagePublisher.message("api_invoke", (Object)apiInvokeRecord);
            ApiInvokeInfo.clear();
        }
        return apiResponseData;
    }

    private ApiServer getServer(MethodInvocation invocation) throws Exception {
        Object[] args = invocation.getArguments();
        String serverUrl = (String)args[1];
        String interfaceUrl = (String)args[2];
        return this.serverService.getByMappingUrl(serverUrl, interfaceUrl);
    }

    public static void processExceptionInfo(ApiInvokeRecord accessRecord, Throwable throwable) {
        if (throwable != null) {
            accessRecord.getApiInvokeRecordDetails().setStacktrace(ExceptionUtil.getRootCauseStackTrace((Throwable)throwable));
            accessRecord.setResponseStatus("failure");
        }
    }
}

