/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway;

import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.info.OperationInfo;
import com.hand.hap.api.gateway.info.ServiceInfo;
import com.hand.hap.api.gateway.util.WsdlUtils;
import com.ibm.wsdl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WsdlParser {
    public ApiServer parseWSDL(ApiServer result, String wsdlURI) throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader reader = wsdlFactory.newWSDLReader();
        Definition defintion = reader.readWSDL(wsdlURI);
        Map servicesMap = defintion.getAllServices();
        Set serviceKeys = servicesMap.keySet();
        Types types = defintion.getTypes();
        List elements = types.getExtensibilityElements();
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)elements.get(0);
        Element element = ((Schema)extensibilityElement).getElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("elementFormDefault");
        String elementFormDefault = "unqualified";
        if (node != null) {
            elementFormDefault = node.getNodeValue();
        }
        for (Object key : serviceKeys) {
            ServiceImpl serviceImpl = (ServiceImpl)servicesMap.get(key);
            List services = this.processService(serviceImpl);
            result.setCode(serviceImpl.getQName().getLocalPart());
            result.setNamespace(defintion.getTargetNamespace());
            result.setElementFormDefault(elementFormDefault);
            if (services.size() == 1) {
                this.getApiServer(result, (ServiceInfo)services.get(0));
                continue;
            }
            for (ServiceInfo serviceInfo : services) {
                if (!serviceInfo.getSoapVersion().equals("SOAP12")) continue;
                this.getApiServer(result, serviceInfo);
            }
        }
        return result;
    }

    private void getApiServer(ApiServer result, ServiceInfo serviceInfo) {
        result.setName(serviceInfo.getName());
        result.setDomainUrl(serviceInfo.getLocationURI());
        result.setMappingUrl(result.getCode());
        result.setWssPasswordType("None");
        ArrayList<ApiInterface> interfaces = result.getInterfaces();
        if (interfaces == null) {
            interfaces = new ArrayList<ApiInterface>();
        }
        for (int i = 0; i < serviceInfo.getOperations().size(); ++i) {
            ApiInterface srInterface = new ApiInterface();
            srInterface.setCode(((OperationInfo)serviceInfo.getOperations().get(i)).getName());
            srInterface.setName(((OperationInfo)serviceInfo.getOperations().get(i)).getName());
            srInterface.setInterfaceUrl(((OperationInfo)serviceInfo.getOperations().get(i)).getName());
            srInterface.setSoapVersion(serviceInfo.getSoapVersion());
            srInterface.setSoapAction(((OperationInfo)serviceInfo.getOperations().get(0)).getSoapActionURI());
            srInterface.setEnableFlag("Y");
            srInterface.setMappingUrl(srInterface.getCode());
            srInterface.setInvokeRecordDetails("N");
            interfaces.add(srInterface);
        }
        result.setInterfaces(interfaces);
    }

    private List<ServiceInfo> processService(ServiceImpl service) {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        Collection ports = service.getPorts().values();
        Iterator iterator = ports.iterator();
        while (iterator.hasNext()) {
            ServiceInfo serviceInfo = new ServiceInfo();
            Port port = (Port)iterator.next();
            serviceInfo.setName(port.getName());
            Binding binding = port.getBinding();
            String soapVersion = WsdlUtils.getSOAPVersion((Binding)binding);
            serviceInfo.setSoapVersion(soapVersion);
            if (soapVersion == null) continue;
            List elements = port.getExtensibilityElements();
            if (soapVersion.equals("SOAP11")) {
                SOAPAddress soapAddress = (SOAPAddress)elements.get(0);
                serviceInfo.setLocationURI(soapAddress.getLocationURI());
            } else {
                SOAP12Address soap12Address = (SOAP12Address)elements.get(0);
                serviceInfo.setLocationURI(soap12Address.getLocationURI());
            }
            List operations = binding.getBindingOperations();
            Iterator iterator2 = operations.iterator();
            while (iterator2.hasNext()) {
                OperationInfo operationInfo = new OperationInfo();
                BindingOperation bindingOperation = (BindingOperation)iterator2.next();
                Operation operation = bindingOperation.getOperation();
                operationInfo.setName(operation.getName());
                List operationElements = bindingOperation.getExtensibilityElements();
                if (soapVersion.equals("SOAP11")) {
                    SOAPOperation soapOperation = (SOAPOperation)operationElements.get(0);
                    operationInfo.setSoapActionURI(soapOperation.getSoapActionURI());
                } else {
                    SOAP12Operation soap12Operation = (SOAP12Operation)operationElements.get(0);
                    operationInfo.setSoapActionURI(soap12Operation.getSoapActionURI());
                }
                serviceInfo.addOperation(operationInfo);
            }
            services.add(serviceInfo);
        }
        return services;
    }
}

