/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.application.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.api.application.dto.ApiApplication;
import com.hand.hap.api.application.mapper.ApiApplicationMapper;
import com.hand.hap.api.application.service.IApiAccessLimitService;
import com.hand.hap.api.application.service.IApiApplicationService;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.security.oauth.dto.Oauth2ClientDetails;
import com.hand.hap.security.oauth.service.IOauth2ClientDetailsService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ApiApplicationServiceImpl
extends BaseServiceImpl<ApiApplication>
implements IApiApplicationService {
    @Autowired
    private ApiApplicationMapper applicationMapper;
    @Autowired
    private IOauth2ClientDetailsService clientService;
    @Autowired
    private IApiServerService serverService;
    @Autowired
    private IApiAccessLimitService accessLimitService;

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApiApplication getById(IRequest request, Long applicationId) {
        ApiApplication application = this.applicationMapper.getById(applicationId);
        String[] ids = StringUtils.commaDelimitedListToStringArray((String)application.getClient().getScope());
        if (ids != null && ids.length > 0) {
            application.setServers(this.serverService.selectByCodes(request, Arrays.asList(ids)));
        }
        return application;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public List<ApiApplication> selectApplications(IRequest request, ApiApplication apiApplication, int page, int pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        return this.applicationMapper.selectApplications(apiApplication);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public List<ApiServer> selectNotExistsServerByApp(IRequest request, String exitsCodes, ApiServer server, int page, int pageSize) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        if (!StringUtils.isEmpty((Object)exitsCodes)) {
            params.put("codeList", StringUtils.commaDelimitedListToStringArray((String)exitsCodes));
        }
        params.put("server", server);
        PageHelper.startPage((int)page, (int)pageSize);
        return this.serverService.selectNotExistsServerByApp(params);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ApiApplication> batchUpdate(IRequest request, List<ApiApplication> list) {
        for (ApiApplication application : list) {
            if (application.getApplicationId() != null) {
                ((IApiApplicationService)this.self()).updateApplication(request, application);
                continue;
            }
            ((IApiApplicationService)this.self()).insertApplication(request, application);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiApplication insertApplication(IRequest request, ApiApplication application) {
        Oauth2ClientDetails client = (Oauth2ClientDetails)this.clientService.insertSelective(request, (Object)application.getClient());
        application.setCliId(client.getId());
        this.applicationMapper.insertSelective((Object)application);
        this.accessLimitService.updateByApplication("", application);
        return application;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiApplication updateApplication(IRequest request, @StdWho ApiApplication application) {
        this.updateByPrimaryKey(request, (Object)application);
        Oauth2ClientDetails oauth2ClientDetails = this.clientService.selectByClientId(application.getClient().getClientId());
        this.clientService.updateClient(request, application.getClient());
        String before = oauth2ClientDetails.getScope();
        this.accessLimitService.updateByApplication(before, application);
        this.accessLimitService.updateAccessLimit(request, application);
        return application;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(ApiApplication record) {
        Long cliId = record.getCliId();
        Oauth2ClientDetails clientDetails = new Oauth2ClientDetails();
        clientDetails.setId(cliId);
        this.accessLimitService.removeByClientId(cliId);
        this.clientService.deleteByPrimaryKey((Object)clientDetails);
        return this.applicationMapper.deleteByPrimaryKey((Object)record);
    }
}

