/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.service.impl;

import com.hand.hap.activiti.custom.IActivitiBean;
import com.hand.hap.activiti.service.IActivitiEntityService;
import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.hr.mapper.EmployeeMapper;
import com.hand.hap.hr.mapper.PositionMapper;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ActivitiEntityServiceImpl
implements IActivitiEntityService,
IActivitiBean {
    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private PositionMapper positionMapper;

    public String getDirector(String employeeCode) {
        List director = this.employeeMapper.getDirector(employeeCode);
        if (director == null || director.isEmpty()) {
            return "ADMIN";
        }
        HashSet<String> directorCode = new HashSet<String>();
        for (Employee employee : director) {
            directorCode.add(employee.getEmployeeCode());
        }
        return StringUtils.collectionToCommaDelimitedString(directorCode);
    }

    public String getDeptDirector(String employeeCode) {
        List director = this.employeeMapper.getDeptDirector(employeeCode);
        if (director == null || director.isEmpty()) {
            return "ADMIN";
        }
        HashSet<String> directorCode = new HashSet<String>();
        for (Employee employee : director) {
            directorCode.add(employee.getEmployeeCode());
        }
        return StringUtils.collectionToCommaDelimitedString(directorCode);
    }

    public boolean isMemberOfGroup(String userId, String groupId) {
        return true;
    }

    public String getName(String userId) {
        return this.getEmployee(userId).getFirstName();
    }

    public String getEmail(String userId) {
        return this.getEmployee(userId).getEmail();
    }

    public UserEntity getEmployee(String employeeCode) {
        return ActivitiUtils.toActivitiUser((Employee)this.employeeMapper.queryByCode(employeeCode));
    }

    public String getGroupName(String groupId) {
        Position pos = this.positionMapper.getPositionByCode(groupId);
        if (pos == null) {
            return groupId;
        }
        return pos.getName();
    }

    public String getEmployeeCode(String employeeCode) {
        return employeeCode;
    }

    public List<String> getPositionEmp(String positionCode) {
        return this.employeeMapper.selectByPostionCode(positionCode).stream().map(t -> t.getEmployeeCode()).collect(Collectors.toList());
    }

    public List<String> getRoleEmp(String roleCode) {
        List employees = this.employeeMapper.selectByRoleCode(roleCode);
        return employees.stream().map(t -> t.getEmployeeCode()).collect(Collectors.toList());
    }

    public String getBeanName() {
        return "empService";
    }
}

