/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.service;

import com.hand.hap.activiti.dto.ActivitiNode;
import com.hand.hap.activiti.dto.HistoricProcessInstanceResponseExt;
import com.hand.hap.activiti.dto.ProcessInstanceForecast;
import com.hand.hap.activiti.dto.TaskActionRequestExt;
import com.hand.hap.activiti.dto.TaskResponseExt;
import com.hand.hap.activiti.exception.TaskActionException;
import com.hand.hap.activiti.exception.WflSecurityException;
import com.hand.hap.activiti.exception.dto.ActiviException;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.ProxySelf;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.repository.Model;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.history.HistoricProcessInstanceQueryRequest;
import org.activiti.rest.service.api.history.HistoricTaskInstanceQueryRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceCreateRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.api.runtime.task.TaskQueryRequest;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

public interface IActivitiService
extends ProxySelf<IActivitiService> {
    public ProcessInstanceResponse startProcess(IRequest var1, ProcessInstanceCreateRequest var2);

    public Model deployModel(String var1) throws Exception;

    public void completeTask(IRequest var1, Task var2, TaskActionRequestExt var3) throws TaskActionException;

    public void delegateTask(IRequest var1, Task var2, TaskActionRequestExt var3) throws TaskActionException;

    public void carbonCopy(IRequest var1, Task var2, TaskActionRequestExt var3) throws TaskActionException;

    public void resolveTask(IRequest var1, Task var2, TaskActionRequestExt var3) throws TaskActionException;

    public void jumpTo(IRequest var1, Task var2, TaskActionRequestExt var3);

    @Transactional
    public void executeTaskAction(IRequest var1, String var2, TaskActionRequestExt var3, boolean var4) throws TaskActionException;

    public List<ActivitiNode> getProcessNodes(IRequest var1, String var2);

    public List<ActivitiNode> getUserTaskFromModelSource(IRequest var1, String var2);

    public String getEmployeeName(String var1);

    public String getGroupName(String var1);

    public TaskResponseExt getTaskDetails(IRequest var1, String var2) throws WflSecurityException;

    public TaskResponseExt getTaskDetails(IRequest var1, String var2, boolean var3) throws WflSecurityException;

    public HistoricProcessInstanceResponseExt getInstanceDetail(IRequest var1, String var2);

    public DataResponse queryTaskList(IRequest var1, TaskQueryRequest var2, Map<String, String> var3);

    public DataResponse queryProcessInstances(IRequest var1, HistoricProcessInstanceQueryRequest var2, Map<String, String> var3, boolean var4);

    public DataResponse queryHistoricTaskInstances(IRequest var1, HistoricTaskInstanceQueryRequest var2, @RequestParam Map<String, String> var3);

    public Boolean isStartRecall(String var1, String var2);

    public Boolean isTaskRecall(String var1, String var2);

    @Transactional(rollbackFor={Exception.class})
    public void taskRecall(IRequest var1, String var2, String var3);

    @Transactional(rollbackFor={Exception.class})
    public void startRecall(IRequest var1, String var2, String var3);

    public List<ActiviException> queryException(ActiviException var1, int var2, int var3);

    public void executeTaskByAdmin(IRequest var1, String var2, TaskActionRequestExt var3) throws TaskActionException;

    public List<ProcessInstanceForecast> processInstanceForecast(IRequest var1, String var2);

    @Transactional(propagation=Propagation.REQUIRES_NEW, noRollbackFor={Exception.class})
    public void saveException(String var1, ActivitiException var2);

    public void deleteDeployment(String var1, Boolean var2);

    public void deleteProcessInstance(String var1);

    public void processCarbonCopyRead(String var1, String var2);
}

