/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.custom.DefaultProcessDiagramCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.engine.ActivitiException;
import org.activiti.image.exception.ActivitiImageException;
import org.activiti.image.util.ReflectUtil;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public class SvgProcessDiagramCanvas
extends DefaultProcessDiagramCanvas {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SvgProcessDiagramCanvas.class);
    private static Field FIELD_textLine = null;
    private static Field FIELD_fChars = null;
    private static Field FIELD_fCharsStart = null;
    private static Field FIELD_fCharsLimit = null;
    private static boolean field_extra = false;

    public SvgProcessDiagramCanvas(int width, int height, int minX, int minY, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        super(width, height, minX, minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
    }

    public void initialize(String imageType) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        this.g = new SVGGraphics2D(document);
        ((SVGGraphics2D)this.g).setSVGCanvasSize(new Dimension(this.canvasWidth, this.canvasHeight));
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setPaint(Color.black);
        Font font = new Font(this.activityFontName, 1, 11);
        this.g.setFont(font);
        this.fontMetrics = this.g.getFontMetrics();
        LABEL_FONT = new Font(this.labelFontName, 2, 10);
        ANNOTATION_FONT = new Font(this.annotationFontName, 0, 11);
        try {
            USERTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/userTask.png", (ClassLoader)this.customClassLoader));
            SCRIPTTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/scriptTask.png", (ClassLoader)this.customClassLoader));
            SERVICETASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/serviceTask.png", (ClassLoader)this.customClassLoader));
            RECEIVETASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/receiveTask.png", (ClassLoader)this.customClassLoader));
            SENDTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/sendTask.png", (ClassLoader)this.customClassLoader));
            MANUALTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/manualTask.png", (ClassLoader)this.customClassLoader));
            BUSINESS_RULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/businessRuleTask.png", (ClassLoader)this.customClassLoader));
            SHELL_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/shellTask.png", (ClassLoader)this.customClassLoader));
            CAMEL_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/camelTask.png", (ClassLoader)this.customClassLoader));
            MULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/muleTask.png", (ClassLoader)this.customClassLoader));
            TIMER_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/timer.png", (ClassLoader)this.customClassLoader));
            COMPENSATE_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/compensate-throw.png", (ClassLoader)this.customClassLoader));
            COMPENSATE_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/compensate.png", (ClassLoader)this.customClassLoader));
            ERROR_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/error-throw.png", (ClassLoader)this.customClassLoader));
            ERROR_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/error.png", (ClassLoader)this.customClassLoader));
            MESSAGE_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/message-throw.png", (ClassLoader)this.customClassLoader));
            MESSAGE_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/message.png", (ClassLoader)this.customClassLoader));
            SIGNAL_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/signal-throw.png", (ClassLoader)this.customClassLoader));
            SIGNAL_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/activiti/icons/signal.png", (ClassLoader)this.customClassLoader));
        }
        catch (IOException e) {
            LOGGER.warn("Could not load image for process diagram creation: {}", (Object)e.getMessage());
        }
    }

    public InputStream generateImage(String imageType) {
        if (this.closed) {
            throw new ActivitiImageException("ProcessDiagramGenerator already closed");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");){
            ((SVGGraphics2D)this.g).stream((Writer)writer);
        }
        catch (SVGGraphics2DIOException e) {
            throw new ActivitiException("Unable to generate image", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ActivitiException("Unsupported encoding for output stream", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void drawLabel(String text, GraphicInfo graphicInfo, boolean centered) {
        float interline = 1.0f;
        if (text != null && text.length() > 0) {
            Paint originalPaint = this.g.getPaint();
            Font originalFont = this.g.getFont();
            this.g.setPaint(LABEL_COLOR);
            this.g.setFont(LABEL_FONT);
            int wrapWidth = 100;
            int textY = (int)graphicInfo.getY();
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FOREGROUND, this.g.getPaint());
            as.addAttribute(TextAttribute.FONT, this.g.getFont());
            AttributedCharacterIterator aci = as.getIterator();
            FontRenderContext frc = new FontRenderContext(null, true, false);
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            while (lbm.getPosition() < text.length()) {
                String str;
                TextLayout tl = lbm.nextLayout(wrapWidth);
                textY = (int)((float)textY + tl.getAscent());
                Rectangle2D bb = tl.getBounds();
                double tX = graphicInfo.getX();
                if (centered) {
                    tX += (double)((int)(graphicInfo.getWidth() / 2.0 - bb.getWidth() / 2.0));
                }
                if ((str = this.getStr(tl)) != null) {
                    this.g.drawString(str, (int)tX, textY);
                } else {
                    tl.draw(this.g, (float)tX, textY);
                }
                textY = (int)((float)textY + (tl.getDescent() + tl.getLeading() + (interline - 1.0f) * tl.getAscent()));
            }
            this.g.setFont(originalFont);
            this.g.setPaint(originalPaint);
        }
    }

    protected void drawMultilineText(String text, int x, int y, int boxWidth, int boxHeight, boolean centered) {
        int currentHeight;
        int height;
        AttributedString attributedString = new AttributedString(text);
        attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black);
        AttributedCharacterIterator characterIterator = attributedString.getIterator();
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
        String lastLine = null;
        LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, this.g.getFontRenderContext());
        TextLayout layout = null;
        for (currentHeight = 0; measurer.getPosition() < characterIterator.getEndIndex() && currentHeight <= boxHeight; currentHeight += height) {
            int previousPosition = measurer.getPosition();
            layout = measurer.nextLayout(boxWidth);
            height = Float.valueOf(layout.getDescent() + layout.getAscent() + layout.getLeading()).intValue();
            if (currentHeight + height > boxHeight) {
                if (layouts.isEmpty()) break;
                layouts.remove(layouts.size() - 1);
                if (lastLine.length() >= 4) {
                    lastLine = lastLine.substring(0, lastLine.length() - 4) + "...";
                }
                layouts.add(new TextLayout(lastLine, this.g.getFont(), this.g.getFontRenderContext()));
                break;
            }
            layouts.add(layout);
            lastLine = text.substring(previousPosition, measurer.getPosition());
        }
        int currentY = y + (centered ? (boxHeight - currentHeight) / 2 : 0);
        int currentX = 0;
        for (TextLayout textLayout : layouts) {
            currentY = (int)((float)currentY + textLayout.getAscent());
            currentX = x + (centered ? (boxWidth - Double.valueOf(textLayout.getBounds().getWidth()).intValue()) / 2 : 0);
            String str = this.getStr(textLayout);
            if (str != null) {
                this.g.drawString(str, currentX, currentY);
            } else {
                textLayout.draw(this.g, currentX, currentY);
            }
            currentY = (int)((float)currentY + (textLayout.getDescent() + textLayout.getLeading()));
        }
    }

    private static void extraField(Class clazz) {
        if (field_extra) {
            return;
        }
        FIELD_fChars = ReflectionUtils.findField((Class)clazz, (String)"fChars");
        ReflectionUtils.makeAccessible((Field)FIELD_fChars);
        FIELD_fCharsStart = ReflectionUtils.findField((Class)clazz, (String)"fCharsStart");
        ReflectionUtils.makeAccessible((Field)FIELD_fCharsStart);
        FIELD_fCharsLimit = ReflectionUtils.findField((Class)clazz, (String)"fCharsLimit");
        ReflectionUtils.makeAccessible((Field)FIELD_fCharsLimit);
        field_extra = true;
    }

    protected String getStr(TextLayout tl) {
        try {
            if (FIELD_textLine == null) {
                FIELD_textLine = ReflectionUtils.findField(TextLayout.class, (String)"textLine");
                ReflectionUtils.makeAccessible((Field)FIELD_textLine);
            }
            Object textLine = FIELD_textLine.get(tl);
            SvgProcessDiagramCanvas.extraField(textLine.getClass());
            char[] fChars = (char[])FIELD_fChars.get(textLine);
            int fCharsStart = FIELD_fCharsStart.getInt(textLine);
            int fCharsLimit = FIELD_fCharsLimit.getInt(textLine);
            return new String(fChars, fCharsStart, fCharsLimit - fCharsStart);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

