/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.custom.DefaultProcessDiagramCanvas;
import com.hand.hap.activiti.custom.DefaultProcessDiagramGenerator;
import com.hand.hap.activiti.custom.NodeGraphicInfo;
import com.hand.hap.activiti.custom.SvgProcessDiagramCanvas;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.Lane;
import org.activiti.bpmn.model.ManualTask;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Pool;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.TextAnnotation;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.image.ProcessDiagramGenerator;
import org.apache.commons.beanutils.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultProcessDiagramGenerator
implements ProcessDiagramGenerator {
    protected Map<Class<? extends BaseElement>, ActivityDrawInstruction> activityDrawInstructions = new HashMap();
    protected Map<Class<? extends BaseElement>, ArtifactDrawInstruction> artifactDrawInstructions = new HashMap();

    public DefaultProcessDiagramGenerator() {
        this(1.0);
    }

    public DefaultProcessDiagramGenerator(double scaleFactor) {
        this.activityDrawInstructions.put(StartEvent.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(IntermediateCatchEvent.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ThrowEvent.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(EndEvent.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(Task.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(UserTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ScriptTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ServiceTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ReceiveTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(SendTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ManualTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(BusinessRuleTask.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ExclusiveGateway.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(InclusiveGateway.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(ParallelGateway.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(EventGateway.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(BoundaryEvent.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(SubProcess.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(EventSubProcess.class, new /* Unavailable Anonymous Inner Class!! */);
        this.activityDrawInstructions.put(CallActivity.class, new /* Unavailable Anonymous Inner Class!! */);
        this.artifactDrawInstructions.put(TextAnnotation.class, new /* Unavailable Anonymous Inner Class!! */);
        this.artifactDrawInstructions.put(Association.class, new /* Unavailable Anonymous Inner Class!! */);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateProcessDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateImage(imageType);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, null, null, null, null, 1.0);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, double scaleFactor) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, null, null, null, null, scaleFactor);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, Collections.emptyList());
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, double scaleFactor) {
        return this.generateDiagram(bpmnModel, imageType, highLightedActivities, Collections.emptyList(), scaleFactor);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        return this.generateDiagram(bpmnModel, imageType, Collections.emptyList(), Collections.emptyList(), activityFontName, labelFontName, annotationFontName, customClassLoader, 1.0);
    }

    public InputStream generateDiagram(BpmnModel bpmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateDiagram(bpmnModel, imageType, Collections.emptyList(), Collections.emptyList(), activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor);
    }

    public InputStream generatePngDiagram(BpmnModel bpmnModel) {
        return this.generatePngDiagram(bpmnModel, 1.0);
    }

    public InputStream generatePngDiagram(BpmnModel bpmnModel, double scaleFactor) {
        return this.generateDiagram(bpmnModel, "png", Collections.emptyList(), Collections.emptyList(), scaleFactor);
    }

    public InputStream generateJpgDiagram(BpmnModel bpmnModel) {
        return this.generateJpgDiagram(bpmnModel, 1.0);
    }

    public InputStream generateJpgDiagram(BpmnModel bpmnModel, double scaleFactor) {
        return this.generateDiagram(bpmnModel, "jpg", Collections.emptyList(), Collections.emptyList());
    }

    public BufferedImage generateImage(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateProcessDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateBufferedImage(imageType);
    }

    public BufferedImage generateImage(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, double scaleFactor) {
        return this.generateImage(bpmnModel, imageType, highLightedActivities, highLightedFlows, null, null, null, null, scaleFactor);
    }

    public BufferedImage generatePngImage(BpmnModel bpmnModel, double scaleFactor) {
        return this.generateImage(bpmnModel, "png", Collections.emptyList(), Collections.emptyList(), scaleFactor);
    }

    protected DefaultProcessDiagramCanvas generateProcessDiagram(BpmnModel bpmnModel, String imageType, List<String> highLightedActivities, List<String> highLightedFlows, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        this.prepareBpmnModel(bpmnModel);
        DefaultProcessDiagramCanvas processDiagramCanvas = DefaultProcessDiagramGenerator.initProcessDiagramCanvas((BpmnModel)bpmnModel, (String)imageType, (String)activityFontName, (String)labelFontName, (String)annotationFontName, (ClassLoader)customClassLoader);
        for (Pool pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            processDiagramCanvas.drawPoolOrLane(pool.getName(), graphicInfo);
        }
        for (Process process : bpmnModel.getProcesses()) {
            for (Lane lane : process.getLanes()) {
                GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(lane.getId());
                processDiagramCanvas.drawPoolOrLane(lane.getName(), graphicInfo);
            }
        }
        for (FlowNode flowNode : ((Process)bpmnModel.getProcesses().get(0)).findFlowElementsOfType(FlowNode.class)) {
            this.drawActivity(processDiagramCanvas, bpmnModel, flowNode, highLightedActivities, highLightedFlows, scaleFactor);
        }
        for (Process process : bpmnModel.getProcesses()) {
            for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
                this.drawActivity(processDiagramCanvas, bpmnModel, flowNode, highLightedActivities, highLightedFlows, scaleFactor);
            }
        }
        for (Process process : bpmnModel.getProcesses()) {
            for (Artifact artifact : process.getArtifacts()) {
                this.drawArtifact(processDiagramCanvas, bpmnModel, artifact);
            }
            List subProcesses = process.findFlowElementsOfType(SubProcess.class, true);
            if (subProcesses == null) continue;
            for (SubProcess subProcess : subProcesses) {
                for (Artifact subProcessArtifact : subProcess.getArtifacts()) {
                    this.drawArtifact(processDiagramCanvas, bpmnModel, subProcessArtifact);
                }
            }
        }
        return processDiagramCanvas;
    }

    protected void prepareBpmnModel(BpmnModel bpmnModel) {
        ArrayList allGraphicInfos = new ArrayList();
        if (bpmnModel.getLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLocationMap().values());
        }
        if (bpmnModel.getLabelLocationMap() != null) {
            allGraphicInfos.addAll(bpmnModel.getLabelLocationMap().values());
        }
        if (bpmnModel.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : bpmnModel.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (!allGraphicInfos.isEmpty()) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    protected void drawActivity(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, FlowNode flowNode, List<String> highLightedActivities, List<String> highLightedFlows, double scaleFactor) {
        ActivityDrawInstruction drawInstruction = (ActivityDrawInstruction)this.activityDrawInstructions.get(flowNode.getClass());
        if (drawInstruction != null) {
            Activity activity;
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics;
            GraphicInfo oriGraphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            NodeGraphicInfo nodeGraphicInfo = new NodeGraphicInfo();
            try {
                BeanUtils.copyProperties((Object)nodeGraphicInfo, (Object)oriGraphicInfo);
                if (highLightedActivities.contains(flowNode.getId())) {
                    nodeGraphicInfo.setColor(new Color(173, 255, 47));
                } else if (highLightedActivities.contains(flowNode.getId() + "__his__")) {
                    nodeGraphicInfo.setColor(new Color(30, 144, 255));
                }
                bpmnModel.getLocationMap().put(flowNode.getId(), nodeGraphicInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            drawInstruction.draw(processDiagramCanvas, bpmnModel, flowNode);
            boolean multiInstanceSequential = false;
            boolean multiInstanceParallel = false;
            boolean collapsed = false;
            if (flowNode instanceof Activity && (multiInstanceLoopCharacteristics = (activity = (Activity)flowNode).getLoopCharacteristics()) != null) {
                multiInstanceSequential = multiInstanceLoopCharacteristics.isSequential();
                multiInstanceParallel = !multiInstanceSequential;
            }
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            if (flowNode instanceof SubProcess) {
                collapsed = graphicInfo.getExpanded() != null && graphicInfo.getExpanded() == false;
            } else if (flowNode instanceof CallActivity) {
                collapsed = true;
            }
            if (scaleFactor == 1.0) {
                processDiagramCanvas.drawActivityMarkers((int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight(), multiInstanceSequential, multiInstanceParallel, collapsed);
            }
            if (highLightedActivities.contains(flowNode.getId()) || highLightedActivities.contains(flowNode.getId() + "__his__")) {
                // empty if block
            }
            bpmnModel.getLocationMap().put(flowNode.getId(), oriGraphicInfo);
        }
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            boolean hor;
            boolean highLighted = highLightedFlows.contains(sequenceFlow.getId());
            String defaultFlow = null;
            if (flowNode instanceof Activity) {
                defaultFlow = ((Activity)flowNode).getDefaultFlow();
            } else if (flowNode instanceof Gateway) {
                defaultFlow = ((Gateway)flowNode).getDefaultFlow();
            }
            boolean isDefault = false;
            if (defaultFlow != null && defaultFlow.equalsIgnoreCase(sequenceFlow.getId())) {
                isDefault = true;
            }
            boolean drawConditionalIndicator = sequenceFlow.getConditionExpression() != null && !(flowNode instanceof Gateway);
            String sourceRef = sequenceFlow.getSourceRef();
            String targetRef = sequenceFlow.getTargetRef();
            FlowElement sourceElement = bpmnModel.getFlowElement(sourceRef);
            FlowElement targetElement = bpmnModel.getFlowElement(targetRef);
            List graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
            if (graphicInfoList == null || graphicInfoList.size() <= 0) continue;
            graphicInfoList = DefaultProcessDiagramGenerator.connectionPerfectionizer((DefaultProcessDiagramCanvas)processDiagramCanvas, (BpmnModel)bpmnModel, (BaseElement)sourceElement, (BaseElement)targetElement, (List)graphicInfoList);
            int[] xPoints = new int[graphicInfoList.size()];
            int[] yPoints = new int[graphicInfoList.size()];
            for (int i = 1; i < graphicInfoList.size(); ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)graphicInfoList.get(i);
                GraphicInfo previousGraphicInfo = (GraphicInfo)graphicInfoList.get(i - 1);
                if (i == 1) {
                    xPoints[0] = (int)previousGraphicInfo.getX();
                    yPoints[0] = (int)previousGraphicInfo.getY();
                }
                xPoints[i] = (int)graphicInfo.getX();
                yPoints[i] = (int)graphicInfo.getY();
            }
            processDiagramCanvas.drawSequenceflow(xPoints, yPoints, drawConditionalIndicator, isDefault, highLighted, scaleFactor);
            GraphicInfo labelGraphicInfo = bpmnModel.getLabelGraphicInfo(sequenceFlow.getId());
            if (labelGraphicInfo != null) {
                processDiagramCanvas.drawLabel(sequenceFlow.getName(), labelGraphicInfo, false);
                continue;
            }
            List list = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
            GraphicInfo gi0 = (GraphicInfo)list.get(0);
            GraphicInfo gi1 = (GraphicInfo)list.get(1);
            List first2 = list.subList(0, 2);
            GraphicInfo center = DefaultProcessDiagramGenerator.getLineCenter(first2);
            boolean bl = hor = gi0.getY() == gi1.getY();
            if (hor) {
                center.setY(center.getY() - 14.0);
            }
            processDiagramCanvas.drawLabel(sequenceFlow.getName(), center, hor);
        }
        if (flowNode instanceof FlowElementsContainer) {
            for (FlowElement nestedFlowElement : ((FlowElementsContainer)flowNode).getFlowElements()) {
                if (!(nestedFlowElement instanceof FlowNode)) continue;
                this.drawActivity(processDiagramCanvas, bpmnModel, (FlowNode)nestedFlowElement, highLightedActivities, highLightedFlows, scaleFactor);
            }
        }
    }

    protected static List<GraphicInfo> connectionPerfectionizer(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, BaseElement sourceElement, BaseElement targetElement, List<GraphicInfo> graphicInfoList) {
        GraphicInfo sourceGraphicInfo = bpmnModel.getGraphicInfo(sourceElement.getId());
        GraphicInfo targetGraphicInfo = bpmnModel.getGraphicInfo(targetElement.getId());
        DefaultProcessDiagramCanvas.SHAPE_TYPE sourceShapeType = DefaultProcessDiagramGenerator.getShapeType((BaseElement)sourceElement);
        DefaultProcessDiagramCanvas.SHAPE_TYPE targetShapeType = DefaultProcessDiagramGenerator.getShapeType((BaseElement)targetElement);
        return processDiagramCanvas.connectionPerfectionizer(sourceShapeType, targetShapeType, sourceGraphicInfo, targetGraphicInfo, graphicInfoList);
    }

    protected static DefaultProcessDiagramCanvas.SHAPE_TYPE getShapeType(BaseElement baseElement) {
        if (baseElement instanceof Task || baseElement instanceof Activity || baseElement instanceof TextAnnotation) {
            return DefaultProcessDiagramCanvas.SHAPE_TYPE.Rectangle;
        }
        if (baseElement instanceof Gateway) {
            return DefaultProcessDiagramCanvas.SHAPE_TYPE.Rhombus;
        }
        if (baseElement instanceof Event) {
            return DefaultProcessDiagramCanvas.SHAPE_TYPE.Ellipse;
        }
        return null;
    }

    protected static GraphicInfo getLineCenter(List<GraphicInfo> graphicInfoList) {
        GraphicInfo gi = new GraphicInfo();
        int[] xPoints = new int[graphicInfoList.size()];
        int[] yPoints = new int[graphicInfoList.size()];
        double length = 0.0;
        double[] lengths = new double[graphicInfoList.size()];
        lengths[0] = 0.0;
        for (int i = 1; i < graphicInfoList.size(); ++i) {
            GraphicInfo graphicInfo = graphicInfoList.get(i);
            GraphicInfo previousGraphicInfo = graphicInfoList.get(i - 1);
            if (i == 1) {
                xPoints[0] = (int)previousGraphicInfo.getX();
                yPoints[0] = (int)previousGraphicInfo.getY();
            }
            xPoints[i] = (int)graphicInfo.getX();
            yPoints[i] = (int)graphicInfo.getY();
            lengths[i] = length += Math.sqrt(Math.pow((int)graphicInfo.getX() - (int)previousGraphicInfo.getX(), 2.0) + Math.pow((int)graphicInfo.getY() - (int)previousGraphicInfo.getY(), 2.0));
        }
        double m = length / 2.0;
        int p1 = 0;
        int p2 = 1;
        int i = 1;
        while (i < lengths.length) {
            double len = lengths[i];
            p1 = i - 1;
            p2 = i++;
            if (len > m) break;
        }
        GraphicInfo graphicInfo1 = graphicInfoList.get(p1);
        GraphicInfo graphicInfo2 = graphicInfoList.get(p2);
        double AB = (int)graphicInfo2.getX() - (int)graphicInfo1.getX();
        double OA = (int)graphicInfo2.getY() - (int)graphicInfo1.getY();
        double OB = lengths[p2] - lengths[p1];
        double ob = m - lengths[p1];
        double ab = AB * ob / OB;
        double oa = OA * ob / OB;
        double mx = graphicInfo1.getX() + ab;
        double my = graphicInfo1.getY() + oa;
        gi.setX(mx);
        gi.setY(my);
        return gi;
    }

    protected void drawArtifact(DefaultProcessDiagramCanvas processDiagramCanvas, BpmnModel bpmnModel, Artifact artifact) {
        ArtifactDrawInstruction drawInstruction = (ArtifactDrawInstruction)this.artifactDrawInstructions.get(artifact.getClass());
        if (drawInstruction != null) {
            drawInstruction.draw(processDiagramCanvas, bpmnModel, artifact);
        }
    }

    private static void drawHighLight(DefaultProcessDiagramCanvas processDiagramCanvas, GraphicInfo graphicInfo) {
        processDiagramCanvas.drawHighLight((int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight());
    }

    private static void drawHighLightHis(DefaultProcessDiagramCanvas processDiagramCanvas, GraphicInfo graphicInfo, FlowNode flowNode) {
        processDiagramCanvas.drawHighLightHis((int)graphicInfo.getX(), (int)graphicInfo.getY(), (int)graphicInfo.getWidth(), (int)graphicInfo.getHeight(), flowNode);
    }

    protected static DefaultProcessDiagramCanvas initProcessDiagramCanvas(BpmnModel bpmnModel, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        double minX = Double.MAX_VALUE;
        double maxX = 0.0;
        double minY = Double.MAX_VALUE;
        double maxY = 0.0;
        for (Object pool : bpmnModel.getPools()) {
            GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(pool.getId());
            minX = graphicInfo.getX();
            maxX = graphicInfo.getX() + graphicInfo.getWidth();
            minY = graphicInfo.getY();
            maxY = graphicInfo.getY() + graphicInfo.getHeight();
        }
        List flowNodes = DefaultProcessDiagramGenerator.gatherAllFlowNodes((BpmnModel)bpmnModel);
        for (Object flowNode : flowNodes) {
            GraphicInfo flowNodeGraphicInfo = bpmnModel.getGraphicInfo(flowNode.getId());
            if (flowNodeGraphicInfo.getX() + flowNodeGraphicInfo.getWidth() > maxX) {
                maxX = flowNodeGraphicInfo.getX() + flowNodeGraphicInfo.getWidth();
            }
            if (flowNodeGraphicInfo.getX() < minX) {
                minX = flowNodeGraphicInfo.getX();
            }
            if (flowNodeGraphicInfo.getY() + flowNodeGraphicInfo.getHeight() > maxY) {
                maxY = flowNodeGraphicInfo.getY() + flowNodeGraphicInfo.getHeight();
            }
            if (flowNodeGraphicInfo.getY() < minY) {
                minY = flowNodeGraphicInfo.getY();
            }
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                List graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(sequenceFlow.getId());
                if (graphicInfoList == null) continue;
                Iterator iterator = graphicInfoList.iterator();
                while (iterator.hasNext()) {
                    GraphicInfo graphicInfo = (GraphicInfo)iterator.next();
                    if (graphicInfo.getX() > maxX) {
                        maxX = graphicInfo.getX();
                    }
                    if (graphicInfo.getX() < minX) {
                        minX = graphicInfo.getX();
                    }
                    if (graphicInfo.getY() > maxY) {
                        maxY = graphicInfo.getY();
                    }
                    if (!(graphicInfo.getY() < minY)) continue;
                    minY = graphicInfo.getY();
                }
            }
        }
        List artifacts = DefaultProcessDiagramGenerator.gatherAllArtifacts((BpmnModel)bpmnModel);
        for (Artifact artifact : artifacts) {
            List graphicInfoList;
            GraphicInfo artifactGraphicInfo = bpmnModel.getGraphicInfo(artifact.getId());
            if (artifactGraphicInfo != null) {
                if (artifactGraphicInfo.getX() + artifactGraphicInfo.getWidth() > maxX) {
                    maxX = artifactGraphicInfo.getX() + artifactGraphicInfo.getWidth();
                }
                if (artifactGraphicInfo.getX() < minX) {
                    minX = artifactGraphicInfo.getX();
                }
                if (artifactGraphicInfo.getY() + artifactGraphicInfo.getHeight() > maxY) {
                    maxY = artifactGraphicInfo.getY() + artifactGraphicInfo.getHeight();
                }
                if (artifactGraphicInfo.getY() < minY) {
                    minY = artifactGraphicInfo.getY();
                }
            }
            if ((graphicInfoList = bpmnModel.getFlowLocationGraphicInfo(artifact.getId())) == null) continue;
            for (GraphicInfo graphicInfo : graphicInfoList) {
                if (graphicInfo.getX() > maxX) {
                    maxX = graphicInfo.getX();
                }
                if (graphicInfo.getX() < minX) {
                    minX = graphicInfo.getX();
                }
                if (graphicInfo.getY() > maxY) {
                    maxY = graphicInfo.getY();
                }
                if (!(graphicInfo.getY() < minY)) continue;
                minY = graphicInfo.getY();
            }
        }
        int nrOfLanes = 0;
        for (Process process : bpmnModel.getProcesses()) {
            for (Lane l : process.getLanes()) {
                GraphicInfo graphicInfo;
                ++nrOfLanes;
                graphicInfo = bpmnModel.getGraphicInfo(l.getId());
                if (graphicInfo.getX() + graphicInfo.getWidth() > maxX) {
                    maxX = graphicInfo.getX() + graphicInfo.getWidth();
                }
                if (graphicInfo.getX() < minX) {
                    minX = graphicInfo.getX();
                }
                if (graphicInfo.getY() + graphicInfo.getHeight() > maxY) {
                    maxY = graphicInfo.getY() + graphicInfo.getHeight();
                }
                if (!(graphicInfo.getY() < minY)) continue;
                minY = graphicInfo.getY();
            }
        }
        if (flowNodes.isEmpty() && bpmnModel.getPools().isEmpty() && nrOfLanes == 0) {
            minX = 0.0;
            minY = 0.0;
        }
        if ("svg".equalsIgnoreCase(imageType)) {
            return new SvgProcessDiagramCanvas((int)maxX + 10, (int)maxY + 10, (int)minX, (int)minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
        }
        return new DefaultProcessDiagramCanvas((int)maxX + 10, (int)maxY + 10, (int)minX, (int)minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
    }

    protected static List<Artifact> gatherAllArtifacts(BpmnModel bpmnModel) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Process process : bpmnModel.getProcesses()) {
            artifacts.addAll(process.getArtifacts());
        }
        return artifacts;
    }

    protected static List<FlowNode> gatherAllFlowNodes(BpmnModel bpmnModel) {
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        for (Process process : bpmnModel.getProcesses()) {
            flowNodes.addAll(DefaultProcessDiagramGenerator.gatherAllFlowNodes((FlowElementsContainer)process));
        }
        return flowNodes;
    }

    protected static List<FlowNode> gatherAllFlowNodes(FlowElementsContainer flowElementsContainer) {
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            if (flowElement instanceof FlowNode) {
                flowNodes.add((FlowNode)flowElement);
            }
            if (!(flowElement instanceof FlowElementsContainer)) continue;
            flowNodes.addAll(DefaultProcessDiagramGenerator.gatherAllFlowNodes((FlowElementsContainer)((FlowElementsContainer)flowElement)));
        }
        return flowNodes;
    }

    public Map<Class<? extends BaseElement>, ActivityDrawInstruction> getActivityDrawInstructions() {
        return this.activityDrawInstructions;
    }

    public void setActivityDrawInstructions(Map<Class<? extends BaseElement>, ActivityDrawInstruction> activityDrawInstructions) {
        this.activityDrawInstructions = activityDrawInstructions;
    }

    public Map<Class<? extends BaseElement>, ArtifactDrawInstruction> getArtifactDrawInstructions() {
        return this.artifactDrawInstructions;
    }

    public void setArtifactDrawInstructions(Map<Class<? extends BaseElement>, ArtifactDrawInstruction> artifactDrawInstructions) {
        this.artifactDrawInstructions = artifactDrawInstructions;
    }
}

