/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.dto.ApproveChainLine;
import com.hand.hap.activiti.service.impl.HapApproveChain;
import java.util.Collections;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.apache.commons.lang.StringUtils;

public class CustomUserTaskActivityBehavior
extends UserTaskActivityBehavior {
    public CustomUserTaskActivityBehavior(UserTask userTask) {
        super(userTask);
    }

    public void execute(DelegateExecution execution) {
        if (HapApproveChain.CURRENT_LINE.get() == null) {
            super.execute(execution);
            return;
        }
        new UserTaskActivityBehavior(this.byApproveChain(this.userTask)).execute(execution);
    }

    private UserTask byApproveChain(UserTask task) {
        ApproveChainLine currentLine = (ApproveChainLine)HapApproveChain.CURRENT_LINE.get();
        HapApproveChain.CURRENT_LINE.remove();
        if (currentLine == null) {
            return task;
        }
        UserTask userTask = task.clone();
        userTask.setName(task.getName() + " - " + currentLine.getName());
        if (StringUtils.isNotEmpty((String)currentLine.getAssignee())) {
            userTask.setAssignee(currentLine.getAssignee());
        } else if (StringUtils.isNotEmpty((String)currentLine.getAssignGroup())) {
            userTask.setCandidateGroups(Collections.singletonList(currentLine.getAssignGroup()));
            if (userTask.getCandidateUsers() != null) {
                userTask.setCandidateUsers(null);
            }
        }
        if (StringUtils.isNotEmpty((String)currentLine.getFormKey())) {
            userTask.setFormKey(currentLine.getFormKey());
        }
        if (StringUtils.isEmpty((String)userTask.getDocumentation())) {
            userTask.setDocumentation(currentLine.getName());
        }
        return userTask;
    }
}

