/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.custom.process.HistoricProcessInstanceEntityImpl;
import com.hand.hap.activiti.dto.DeploymentResponseExt;
import com.hand.hap.activiti.dto.HistoricProcessInstanceResponseExt;
import com.hand.hap.activiti.dto.HistoricTaskInstanceResponseExt;
import com.hand.hap.activiti.dto.ModelResponseExt;
import com.hand.hap.activiti.dto.ProcessInstanceResponseExt;
import com.hand.hap.activiti.dto.TaskResponseExt;
import java.util.Map;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.RestUrlBuilder;
import org.activiti.rest.service.api.RestUrls;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.history.HistoricProcessInstanceResponse;
import org.activiti.rest.service.api.history.HistoricTaskInstanceResponse;
import org.activiti.rest.service.api.repository.DeploymentResponse;
import org.activiti.rest.service.api.repository.ModelResponse;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.api.runtime.task.TaskResponse;

public class CustomRestResponseFactory
extends RestResponseFactory {
    public TaskResponse createTaskResponse(Task task, RestUrlBuilder urlBuilder) {
        Map variableMap;
        TaskResponseExt response = new TaskResponseExt(task);
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{task.getId()}));
        if (response.getParentTaskId() != null) {
            response.setParentTaskUrl(urlBuilder.buildUrl(RestUrls.URL_TASK, new Object[]{response.getParentTaskId()}));
        }
        if (response.getProcessDefinitionId() != null) {
            response.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{response.getProcessDefinitionId()}));
        }
        if (response.getExecutionId() != null) {
            response.setExecutionUrl(urlBuilder.buildUrl(RestUrls.URL_EXECUTION, new Object[]{response.getExecutionId()}));
        }
        if (response.getProcessInstanceId() != null) {
            response.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{response.getProcessInstanceId()}));
        }
        if (task.getProcessVariables() != null) {
            variableMap = task.getProcessVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, task.getId(), 1, false, urlBuilder));
            }
        }
        if (task.getTaskLocalVariables() != null) {
            variableMap = task.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                response.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, task.getId(), 1, false, urlBuilder));
            }
        }
        return response;
    }

    public HistoricTaskInstanceResponse createHistoricTaskInstanceResponse(HistoricTaskInstance taskInstance, RestUrlBuilder urlBuilder) {
        Map variableMap;
        HistoricTaskInstanceResponseExt result = new HistoricTaskInstanceResponseExt(taskInstance);
        if (taskInstance.getProcessDefinitionId() != null) {
            result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{taskInstance.getProcessDefinitionId()}));
        }
        result.setProcessInstanceId(taskInstance.getProcessInstanceId());
        if (taskInstance.getProcessInstanceId() != null) {
            result.setProcessInstanceUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{taskInstance.getProcessInstanceId()}));
        }
        result.setStartTime(taskInstance.getStartTime());
        result.setTaskDefinitionKey(taskInstance.getTaskDefinitionKey());
        result.setWorkTimeInMillis(taskInstance.getWorkTimeInMillis());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_TASK_INSTANCE, new Object[]{taskInstance.getId()}));
        if (taskInstance.getProcessVariables() != null) {
            variableMap = taskInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.GLOBAL, taskInstance.getId(), 4, false, urlBuilder));
            }
        }
        if (taskInstance.getTaskLocalVariables() != null) {
            variableMap = taskInstance.getTaskLocalVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, taskInstance.getId(), 4, false, urlBuilder));
            }
        }
        return result;
    }

    public HistoricProcessInstanceResponse createHistoricProcessInstanceResponse(HistoricProcessInstance processInstance, RestUrlBuilder urlBuilder) {
        HistoricProcessInstanceResponseExt result = new HistoricProcessInstanceResponseExt();
        result.setProcessName(processInstance.getProcessDefinitionName());
        result.setBusinessKey(processInstance.getBusinessKey());
        result.setDeleteReason(processInstance.getDeleteReason());
        result.setDurationInMillis(processInstance.getDurationInMillis());
        result.setEndActivityId(processInstance.getEndActivityId());
        result.setEndTime(processInstance.getEndTime());
        result.setId(processInstance.getId());
        result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
        result.setStartActivityId(processInstance.getStartActivityId());
        result.setStartTime(processInstance.getStartTime());
        result.setStartUserId(processInstance.getStartUserId());
        result.setSuperProcessInstanceId(processInstance.getSuperProcessInstanceId());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_HISTORIC_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
        if (processInstance.getProcessVariables() != null) {
            Map variableMap = processInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 5, false, urlBuilder));
            }
        }
        result.setTenantId(processInstance.getTenantId());
        if (processInstance instanceof HistoricProcessInstanceEntityImpl) {
            HistoricProcessInstanceEntityImpl customHistoricProcessInstanceEntity = (HistoricProcessInstanceEntityImpl)processInstance;
            result.setTaskDefKey(customHistoricProcessInstanceEntity.getTaskDefKey());
            if (customHistoricProcessInstanceEntity.getSuspensionState() != null) {
                result.setSuspended(SuspensionState.SUSPENDED.getStateCode() == customHistoricProcessInstanceEntity.getSuspensionState().intValue());
            }
            result.setReadFlag(customHistoricProcessInstanceEntity.getReadFlag());
        }
        return result;
    }

    public ProcessInstanceResponse createProcessInstanceResponse(ProcessInstance processInstance, RestUrlBuilder urlBuilder) {
        ProcessInstanceResponseExt result = new ProcessInstanceResponseExt();
        result.setStartTime(processInstance.getStartTime());
        result.setStartUserId(processInstance.getStartUserId());
        result.setProcessDefinitionName(processInstance.getProcessDefinitionName());
        result.setActivityId(processInstance.getActivityId());
        result.setBusinessKey(processInstance.getBusinessKey());
        result.setId(processInstance.getId());
        result.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        result.setProcessDefinitionUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_DEFINITION, new Object[]{processInstance.getProcessDefinitionId()}));
        result.setEnded(processInstance.isEnded());
        result.setSuspended(processInstance.isSuspended());
        result.setUrl(urlBuilder.buildUrl(RestUrls.URL_PROCESS_INSTANCE, new Object[]{processInstance.getId()}));
        result.setTenantId(processInstance.getTenantId());
        if (processInstance.isEnded()) {
            result.setCompleted(true);
        } else {
            result.setCompleted(false);
        }
        if (processInstance.getProcessVariables() != null) {
            Map variableMap = processInstance.getProcessVariables();
            for (String name : variableMap.keySet()) {
                result.addVariable(this.createRestVariable(name, variableMap.get(name), RestVariable.RestVariableScope.LOCAL, processInstance.getId(), 3, false, urlBuilder));
            }
        }
        return result;
    }

    public ModelResponse createModelResponse(Model model, RestUrlBuilder urlBuilder) {
        ModelResponseExt response = new ModelResponseExt();
        response.setCategory(model.getCategory());
        response.setCreateTime(model.getCreateTime());
        response.setId(model.getId());
        response.setKey(model.getKey());
        response.setLastUpdateTime(model.getLastUpdateTime());
        response.setMetaInfo(model.getMetaInfo());
        response.setName(model.getName());
        response.setDeploymentId(model.getDeploymentId());
        response.setVersion(model.getVersion());
        response.setTenantId(model.getTenantId());
        response.setUrl(urlBuilder.buildUrl(RestUrls.URL_MODEL, new Object[]{model.getId()}));
        if (model.getDeploymentId() != null) {
            response.setDeploymentUrl(urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT, new Object[]{model.getDeploymentId()}));
        }
        if (model.hasEditorSource()) {
            response.setSourceUrl(urlBuilder.buildUrl(RestUrls.URL_MODEL_SOURCE, new Object[]{model.getId()}));
        }
        if (model.hasEditorSourceExtra()) {
            response.setSourceExtraUrl(urlBuilder.buildUrl(RestUrls.URL_MODEL_SOURCE_EXTRA, new Object[]{model.getId()}));
        }
        return response;
    }

    public DeploymentResponse createDeploymentResponse(Deployment deployment, RestUrlBuilder urlBuilder) {
        return new DeploymentResponseExt(deployment, urlBuilder.buildUrl(RestUrls.URL_DEPLOYMENT, new Object[]{deployment.getId()}));
    }
}

