/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.components.ApprovalRule;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.util.ActivitiUtils;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior
implements IActivitiConstants {
    @Autowired
    private ApprovalRule approvalRule;

    public CustomParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected int createInstances(DelegateExecution execution) {
        UserTask task;
        if (execution.getCurrentFlowElement() instanceof UserTask && !ActivitiUtils.isAddApproveChain((UserTask)(task = (UserTask)execution.getCurrentFlowElement()))) {
            this.setLoopVariable(execution, "approvalCandidates", (Object)this.approvalRule.getApprovalRule(execution));
        }
        int ret = super.createInstances(execution);
        this.setLoopVariable(execution, "nrOfRejected", (Object)0);
        this.setLoopVariable(execution, "nrOfApproved", (Object)0);
        return ret;
    }

    public void leave(DelegateExecution execution) {
        String approveResult = String.valueOf(execution.getVariable("approveResult"));
        DelegateExecution rootExecution = this.getMultiInstanceRootExecution(execution);
        if (this.isRejected(approveResult)) {
            this.setLoopVariable(rootExecution, "nrOfRejected", (Object)(this.getLoopVariable(rootExecution, "nrOfRejected") + 1));
        } else if (this.isApproved(approveResult)) {
            this.setLoopVariable(rootExecution, "nrOfApproved", (Object)(this.getLoopVariable(rootExecution, "nrOfApproved") + 1));
        }
        super.leave(execution);
    }
}

