/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/wfl", "/api/wfl"})
public class ModelSaveRestResource
implements ModelDataJsonConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ModelSaveRestResource.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ObjectMapper objectMapper;

    @RequestMapping(value={"/model/{modelId}/save", "/service/model/{modelId}/save"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void saveModel(@PathVariable String modelId, @RequestBody MultiValueMap<String, String> values) {
        try {
            Model model = this.repositoryService.getModel(modelId);
            ObjectNode modelJson = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
            modelJson.put("name", (String)values.getFirst((Object)"name"));
            modelJson.put("description", (String)values.getFirst((Object)"description"));
            model.setMetaInfo(modelJson.toString());
            model.setName((String)values.getFirst((Object)"name"));
            model.setDeploymentId(null);
            this.repositoryService.saveModel(model);
            this.repositoryService.addModelEditorSource(model.getId(), ((String)values.getFirst((Object)"json_xml")).getBytes("utf-8"));
            ByteArrayInputStream svgStream = new ByteArrayInputStream(((String)values.getFirst((Object)"svg_xml")).getBytes("utf-8"));
            TranscoderInput input = new TranscoderInput((InputStream)svgStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            transcoder.transcode(input, output);
            byte[] result = outStream.toByteArray();
            this.repositoryService.addModelEditorSourceExtra(model.getId(), result);
            outStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Error saving model", (Throwable)e);
            throw new ActivitiException("Error saving model", (Throwable)e);
        }
    }
}

