/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.controllers;

import com.hand.hap.activiti.components.ActivitiMultiLanguageManager;
import com.hand.hap.activiti.dto.ModelResponseExt;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.system.service.IPromptService;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.ModelQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.repository.BaseModelResource;
import org.activiti.rest.service.api.repository.ModelsPaginateList;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wfl", "/api/wfl"})
public class ModelCollectionRestResource
extends BaseModelResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap();
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IPromptService promptService;

    @RequestMapping(value={"/repository/models"}, method={RequestMethod.GET}, produces={"application/json"})
    public DataResponse getModels(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        boolean withoutTenantId;
        boolean isLatestVersion;
        IRequest iRequest = RequestHelper.createServiceRequest((HttpServletRequest)request);
        if (ActivitiMultiLanguageManager.multiLanguageOpen && allRequestParams.containsKey("nameLike")) {
            allRequestParams.put("nameLike", ActivitiMultiLanguageManager.getMultiLanguageInfoByDescription((String)allRequestParams.get("nameLike"), (IRequest)iRequest));
        }
        ModelQuery modelQuery = this.repositoryService.createModelQuery();
        if (allRequestParams.containsKey("id")) {
            modelQuery.modelId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("category")) {
            modelQuery.modelCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            modelQuery.modelCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            modelQuery.modelCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("name")) {
            modelQuery.modelName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            modelQuery.modelNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("key")) {
            modelQuery.modelKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("version")) {
            modelQuery.modelVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("latestVersion") && (isLatestVersion = Boolean.valueOf(allRequestParams.get("latestVersion")).booleanValue())) {
            modelQuery.latestVersion();
        }
        if (allRequestParams.containsKey("deploymentId")) {
            modelQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("deployed")) {
            boolean isDeployed = Boolean.valueOf(allRequestParams.get("deployed"));
            if (isDeployed) {
                modelQuery.deployed();
            } else {
                modelQuery.notDeployed();
            }
        }
        if (allRequestParams.containsKey("tenantId")) {
            modelQuery.modelTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            modelQuery.modelTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.valueOf(allRequestParams.get("withoutTenantId")).booleanValue())) {
            modelQuery.modelWithoutTenantId();
        }
        DataResponse dataResponse = new ModelsPaginateList(this.restResponseFactory).paginateList(allRequestParams, (Query)modelQuery, "id", allowedSortProperties);
        if (ActivitiMultiLanguageManager.multiLanguageOpen && CollectionUtils.isNotEmpty((Collection)((List)dataResponse.getData()))) {
            List modelResponseExts = (List)dataResponse.getData();
            for (ModelResponseExt modelResponseExt : modelResponseExts) {
                modelResponseExt.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode((String)modelResponseExt.getName(), (IRequest)iRequest));
            }
        }
        return dataResponse;
    }

    static {
        allowedSortProperties.put("id", ModelQueryProperty.MODEL_ID);
        allowedSortProperties.put("category", ModelQueryProperty.MODEL_CATEGORY);
        allowedSortProperties.put("createTime", ModelQueryProperty.MODEL_CREATE_TIME);
        allowedSortProperties.put("key", ModelQueryProperty.MODEL_KEY);
        allowedSortProperties.put("lastUpdateTime", ModelQueryProperty.MODEL_LAST_UPDATE_TIME);
        allowedSortProperties.put("name", ModelQueryProperty.MODEL_NAME);
        allowedSortProperties.put("version", ModelQueryProperty.MODEL_VERSION);
        allowedSortProperties.put("tenantId", ModelQueryProperty.MODEL_TENANT_ID);
    }
}

