/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.approval.controllers;

import com.hand.hap.activiti.approval.dto.BusinessRuleHeader;
import com.hand.hap.activiti.approval.dto.BusinessRuleLine;
import com.hand.hap.activiti.approval.service.IBusinessRuleHeaderService;
import com.hand.hap.activiti.approval.service.IBusinessRuleLineService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wfl/business/rule", "/api/wfl/business/rule"})
public class BusinessRuleController
extends BaseController {
    @Autowired
    private IBusinessRuleHeaderService service;
    @Autowired
    private IBusinessRuleLineService lineService;

    @RequestMapping(value={"/header/query"})
    @ResponseBody
    public ResponseData query(BusinessRuleHeader dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, (Object)dto, page, pageSize));
    }

    @RequestMapping(value={"/header/queryAll"})
    @ResponseBody
    public ResponseData queryAll(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        BusinessRuleHeader dto = new BusinessRuleHeader();
        dto.setEnableFlag("Y");
        return new ResponseData(this.service.selectAll(requestContext, dto));
    }

    @RequestMapping(value={"/header/submit"})
    @ResponseBody
    public ResponseData update(HttpServletRequest request, @RequestBody List<BusinessRuleHeader> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/header/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<BusinessRuleHeader> dto) {
        IRequest requestCtx = this.createRequestContext(request);
        this.service.batchDelete(requestCtx, dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/line/query"})
    @ResponseBody
    public ResponseData queryLine(BusinessRuleLine dto, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.lineService.selectOptions(requestContext, (Object)dto, null));
    }

    @RequestMapping(value={"/line/remove"})
    @ResponseBody
    public ResponseData deleteLine(HttpServletRequest request, @RequestBody List<BusinessRuleLine> dto) {
        this.lineService.batchDelete(dto);
        return new ResponseData();
    }
}

