/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.mapper.UserMapper;
import com.hand.hap.account.service.IUserInfoService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.cache.impl.UserCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.core.util.ValidateUtils;
import com.hand.hap.mybatis.common.Criteria;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserInfoServiceImpl
implements IUserInfoService {
    private final Logger logger = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    private static final Long BASE_MENBER_EIGHT = 8L;
    @Autowired
    private IUserService userService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserCache userCache;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User create(IRequest request, User user) throws Exception {
        String tmpPassword = this.generateRandomPassword();
        user.setPassword(tmpPassword);
        user = (User)this.userService.insertSelective(request, (Object)user);
        if (user == null) {
            throw new UserException("error.system.user_insert_fail", null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("create user {}", (Object)user.toString());
        }
        return user;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User update(IRequest request, User user) throws BaseException {
        this.userService.validateEmail(user.getEmail());
        this.userService.validatePhone(user.getPhone());
        user.setUserId(request.getUserId());
        Criteria criteria = new Criteria((Object)user);
        criteria.update(new String[]{"email", "phone"});
        criteria.updateExtensionAttribute();
        this.userCache.remove(user.getUserName());
        return (User)this.userService.updateByPrimaryKeyOptions(request, (Object)user, criteria);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<User> getUsers(IRequest request, User user, int page, int pagesize) throws UserException {
        PageHelper.startPage((int)page, (int)pagesize);
        return this.userMapper.select((Object)user);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public User selectUserByPrimaryKey(IRequest request, Long userId) throws UserException {
        User user = new User();
        user.setUserId(userId);
        User checkUser = (User)this.userService.selectByPrimaryKey(request, (Object)user);
        if (checkUser == null) {
            throw new UserException("error.system.user_not_exist", null);
        }
        if (!"ACTV".equals(checkUser.getStatus())) {
            throw new UserException("error.system.user_expired", null);
        }
        return checkUser;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public User selectUserByName(IRequest request, String userName) throws UserException {
        User user = new User();
        user.setUserName(userName);
        User checkUser = this.userMapper.selectByUserName(userName);
        if (checkUser == null) {
            throw new UserException("error.system.user_not_exist", null);
        }
        if (!"ACTV".equals(checkUser.getStatus())) {
            throw new UserException("error.system.user_expired", null);
        }
        return checkUser;
    }

    private List<User> validateUser(IRequest request, User user) throws UserException {
        if (!ValidateUtils.validateUserName((String)user.getUserName())) {
            throw new UserException("error.user.user_format", new Object[0]);
        }
        User checkUser = new User();
        checkUser.setUserName(user.getUserName());
        return this.userMapper.select((Object)checkUser);
    }

    private List<User> validateEmail(IRequest request, User user) throws UserException {
        this.userService.validateEmail(user.getEmail());
        List<Object> list = new ArrayList<User>();
        if ("INNER".equals(user.getUserType())) {
            User checkUser = new User();
            checkUser.setEmail(user.getEmail());
            list = this.userMapper.select((Object)checkUser);
        }
        return list;
    }

    private List<User> validatePhone(IRequest request, User user) throws UserException {
        this.userService.validatePhone(user.getPhone());
        List<Object> list = new ArrayList<User>();
        if ("INNER".equals(user.getUserType())) {
            User checkUser = new User();
            checkUser.setPhone(user.getPhone());
            list = this.userMapper.select((Object)checkUser);
        }
        return list;
    }

    private String generateRandomPassword() {
        StringBuilder password = new StringBuilder();
        int i = 0;
        while ((long)i < BASE_MENBER_EIGHT) {
            password.append((int)(Math.random() * 9.0));
            ++i;
        }
        return password.toString();
    }
}

