/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.account.dto.Role;
import com.hand.hap.account.dto.RoleExt;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.RoleException;
import com.hand.hap.account.mapper.RoleMapper;
import com.hand.hap.account.mapper.UserRoleMapper;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends BaseServiceImpl<Role>
implements IRoleService {
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IUserService iUserService;

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Role> selectRoles(IRequest request, Role role, int pageNum, int pageSize) {
        Criteria criteria = new Criteria((Object)role);
        criteria.where(new Object[]{"roleId", new WhereField("roleCode", Comparison.LIKE), new WhereField("roleName", Comparison.LIKE), new WhereField("roleDescription", Comparison.LIKE)});
        return super.selectOptions(request, (Object)role, criteria, Integer.valueOf(pageNum), Integer.valueOf(pageSize));
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectRoleNotUserRoles(IRequest request, RoleExt roleExt, int page, int pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        List list = this.roleMapper.selectRoleNotUserRoles(roleExt);
        return list;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectRolesByUser(IRequest requestContext, User user) {
        List rootRoles = this.roleMapper.selectUserRoles(user.getUserId());
        return rootRoles;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectUserRolesByUserId(Long userId) {
        List rootRoles = this.roleMapper.selectUserRolesByUserId(userId);
        return rootRoles;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public void checkUserRoleExists(Long userId, Long roleId) throws RoleException {
        if (this.roleMapper.selectUserRoleCount(userId, roleId) != 1) {
            throw new RoleException("error.account_role_invalid", "error.account_role_invalid", null);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IRole selectRoleByCode(String roleCode) {
        IRole role = (IRole)this.getRoleCache().getValue(roleCode);
        if (role == null) {
            Role record = new Role();
            record.setRoleCode(roleCode);
            role = (IRole)this.roleMapper.selectOne((Object)record);
            if (role != null) {
                this.getRoleCache().setValue(roleCode, (Object)role);
            }
        }
        return role;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectActiveRolesByUser(IRequest requestContext, User user) {
        if (null == user.getRoleCode()) {
            user = this.iUserService.selectByUserName(user.getUserName());
        }
        ArrayList<IRole> roles = new ArrayList<IRole>();
        for (String roleCode : user.getRoleCode()) {
            roles.add(this.selectRoleByCode(roleCode));
        }
        return roles.stream().filter(role -> role.isActive()).collect(Collectors.toList());
    }

    protected boolean useSelectiveUpdate() {
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(Role record) {
        int ret = super.deleteByPrimaryKey((Object)record);
        this.userRoleMapper.deleteByRoleId(record.getRoleId());
        this.roleFunctionService.removeRoleFunctionByRoleId(record.getRoleId());
        this.getRoleCache().remove(record.getRoleCode());
        return ret;
    }

    @Transactional(rollbackFor={Exception.class})
    public Role updateByPrimaryKey(IRequest request, @StdWho Role record) {
        int count = this.roleMapper.updateByPrimaryKey((Object)record);
        this.checkOvn(count, (Object)record);
        this.getRoleCache().remove(record.getRoleCode());
        this.getRoleCache().setValue(record.getRoleCode(), (Object)record);
        return record;
    }

    @Transactional(rollbackFor={Exception.class})
    public Role insertSelective(IRequest request, Role record) {
        int count = this.roleMapper.insertSelective((Object)record);
        this.checkOvn(count, (Object)record);
        this.getRoleCache().setValue(record.getRoleCode(), (Object)record);
        return record;
    }

    private Cache<IRole> getRoleCache() {
        return this.cacheManager.getCache("role");
    }
}

