/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.controllers;

import com.hand.hap.attachment.exception.AttachmentException;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.task.dto.TaskExecution;
import com.hand.hap.task.dto.TaskExecutionDetail;
import com.hand.hap.task.service.ITaskExecutionDetailService;
import com.hand.hap.task.service.ITaskExecutionService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/sys/task/execution", "api/sys/task/execution"})
public class TaskExecutionController
extends BaseController {
    private static final Integer BUFFER_SIZE = 1024;
    private static final String ENC = "UTF-8";
    @Autowired
    private ITaskExecutionService iTaskExecutionService;
    @Autowired
    private ITaskExecutionDetailService taskExecutionDetailService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResponseData query(TaskExecution dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        boolean isAdmin = Boolean.valueOf(request.getParameter("isAdmin"));
        return new ResponseData(this.iTaskExecutionService.queryExecutions(iRequest, dto, isAdmin, page, pageSize));
    }

    @GetMapping(value={"/admin/task_execution.html"})
    public ModelAndView adminQuery(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView(this.getViewPath() + "/task/task_execution");
        mv.addObject("isAdmin", (Object)true);
        return mv;
    }

    @PostMapping(value={"/selectExecutionGroup"})
    @ResponseBody
    public ResponseData queryExecutionGroup(@RequestBody TaskExecution taskExecution, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.iTaskExecutionService.queryExecutionGroup(iRequest, taskExecution));
    }

    @PostMapping(value={"/detail"})
    @ResponseBody
    public ResponseData detailByEId(@RequestBody TaskExecution taskExecution, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.iTaskExecutionService.queryExecutionDetail(iRequest, taskExecution));
    }

    @PostMapping(value={"/getExecutionLog"})
    @ResponseBody
    public ResponseData getExecutionLog(@RequestBody TaskExecutionDetail dto, HttpServletRequest request) {
        return new ResponseData(Arrays.asList(this.taskExecutionDetailService.getExecutionLog(dto)));
    }

    @PostMapping(value={"/cancleExecute"})
    @ResponseBody
    public ResponseData cancleExecute(@RequestBody TaskExecution dto, HttpServletRequest request) {
        boolean result = this.iTaskExecutionService.cancelExecute(dto);
        return new ResponseData(result);
    }

    @GetMapping(value={"/detailDownload"})
    @ResponseBody
    public void detailDownload(Long executionId, HttpServletRequest request, HttpServletResponse response) {
        IRequest iRequest = this.createRequestContext(request);
        TaskExecution dto = new TaskExecution();
        dto.setExecutionId(executionId);
        List<TaskExecution> list = this.iTaskExecutionService.queryExecutionDetail(iRequest, dto);
        if (list != null) {
            TaskExecution taskExecution = list.get(0);
            String fileName = taskExecution.getExecutionNumber() + ".log";
            if (taskExecution.getParentId() != null) {
                dto.setExecutionId(taskExecution.getParentId());
                List<TaskExecution> parentExecution = this.iTaskExecutionService.queryExecutionDetail(iRequest, dto);
                if (parentExecution != null) {
                    fileName = parentExecution.get(0).getExecutionNumber() + "-" + taskExecution.getExecutionOrder() + ".log";
                    taskExecution.setExecutionNumber(parentExecution.get(0).getExecutionNumber());
                    taskExecution.setExecutionDescription(parentExecution.get(0).getExecutionDescription());
                    taskExecution.setLastExecuteDate(parentExecution.get(0).getLastExecuteDate());
                }
            }
            try {
                String content = this.iTaskExecutionService.generateString(taskExecution);
                response.addHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, ENC) + "\"");
                response.setContentType("text/plain;charset=UTF-8");
                response.setHeader("Accept-Ranges", "bytes");
                this.writeFileToResp(response, content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @GetMapping(value={"/resultDownload"})
    @ResponseBody
    public void resultDownload(Long executionId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IRequest iRequest = this.createRequestContext(request);
        TaskExecution execution = new TaskExecution();
        execution.setExecutionId(executionId);
        execution = this.iTaskExecutionService.selectByPrimaryKey(iRequest, execution);
        File file = new File(execution.getExecuteResultPath());
        Properties props = System.getProperties();
        String fileSep = props.getProperty("file.separator");
        String fileName = execution.getExecuteResultPath().substring(execution.getExecuteResultPath().lastIndexOf(fileSep) + 1);
        if (file.exists()) {
            response.addHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, ENC) + "\"");
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Accept-Ranges", "bytes");
            int fileLength = (int)file.length();
            response.setContentLength(fileLength);
            if (fileLength > 0) {
                this.writeFileToResp(response, file);
            }
        } else {
            throw new AttachmentException("msg.warning.download.file.error", "msg.warning.download.file.error", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToResp(HttpServletResponse response, Object content) {
        byte[] buf = new byte[BUFFER_SIZE.intValue()];
        InputStream inStream = null;
        ServletOutputStream outputStream = null;
        try {
            int readLength;
            if (content.getClass() == String.class) {
                inStream = new ByteArrayInputStream(content.toString().getBytes());
            } else if (content.getClass() == File.class) {
                inStream = new FileInputStream((File)content);
            }
            outputStream = response.getOutputStream();
            while ((readLength = inStream.read(buf)) != -1) {
                outputStream.write(buf, 0, readLength);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

