/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.dto.GlobalProfile;
import com.hand.hap.system.dto.Profile;
import com.hand.hap.system.dto.ProfileValue;
import com.hand.hap.system.mapper.ProfileMapper;
import com.hand.hap.system.mapper.ProfileValueMapper;
import com.hand.hap.system.service.IProfileService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProfileServiceImpl
extends BaseServiceImpl<Profile>
implements IProfileService {
    private static ProfileValue GLOBAL = new ProfileValue();
    private Logger logger = LoggerFactory.getLogger(ProfileServiceImpl.class);
    @Autowired
    private ProfileMapper profileMapper;
    @Autowired
    private ProfileValueMapper profileValueMapper;
    @Autowired
    private IMessagePublisher messagePublisher;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Profile> selectProfiles(Profile profile, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.profileMapper.select(profile);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Profile createProfile(IRequest request, @StdWho Profile profile) {
        this.profileMapper.insertSelective(profile);
        if (profile.getProfileValues() != null) {
            this.processProfileValues(profile);
        }
        return profile;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<ProfileValue> selectProfileValues(ProfileValue value) {
        return this.profileValueMapper.selectProfileValues(value);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchDelete(IRequest request, List<Profile> profiles) {
        for (Profile profile : profiles) {
            ProfileValue profileValue = new ProfileValue();
            profileValue.setProfileId(profile.getProfileId());
            int count = this.profileValueMapper.deleteByProfileId(profileValue);
            this.checkOvn(count, profileValue);
            int countH = this.profileMapper.deleteByPrimaryKey(profile);
            this.checkOvn(countH, profile);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchDeleteValues(IRequest requestContext, List<ProfileValue> values) {
        for (ProfileValue value : values) {
            int count = this.profileValueMapper.deleteByPrimaryKey(value);
            this.checkOvn(count, value);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Profile updateProfile(IRequest request, @StdWho Profile profile) {
        int count = this.profileMapper.updateByPrimaryKeySelective(profile);
        this.checkOvn(count, profile);
        if (profile.getProfileValues() != null) {
            this.processProfileValues(profile);
        }
        return profile;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Profile> batchUpdate(IRequest request, @StdWho List<Profile> profiles) {
        for (Profile profile : profiles) {
            if (profile.getProfileId() == null) {
                ((IProfileService)this.self()).createProfile(request, profile);
                continue;
            }
            if (profile.getProfileId() == null) continue;
            ((IProfileService)this.self()).updateProfile(request, profile);
        }
        return profiles;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public String getValueByUserIdAndName(Long userId, String profileName) {
        Profile profile = this.profileMapper.selectByName(profileName);
        if (profile == null) {
            return null;
        }
        Long profileId = profile.getProfileId();
        List<ProfileValue> profileValues = this.profileValueMapper.selectByProfileIdAndUserId(profileId, userId);
        if (profileValues != null && profileValues.size() > 0) {
            return profileValues.get(0).getProfileValue();
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<ProfileValue> selectLevelValues(ProfileValue value, Long levelId, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("levelId:{}", (Object)levelId);
        }
        value.getLevelId();
        if (levelId == null) {
            return null;
        }
        if (levelId == 30L) {
            return this.profileValueMapper.selectLevelValuesForUser(value);
        }
        if (levelId == 20L) {
            return this.profileValueMapper.selectLevelValuesForRole(value);
        }
        if (levelId == 10L) {
            return Arrays.asList(GLOBAL);
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public String getProfileValue(IRequest request, String profileName) {
        List<ProfileValue> profileValues = this.profileValueMapper.selectPriorityValues(profileName);
        if (profileValues != null && profileValues.size() > 0) {
            return profileValues.get(0).getProfileValue();
        }
        return null;
    }

    private void processProfileValues(Profile profile) {
        for (ProfileValue profileValue : profile.getProfileValues()) {
            if (profileValue.getProfileValueId() == null) {
                profileValue.setProfileId(profile.getProfileId());
                this.profileValueMapper.insertSelective(profileValue);
            } else if (profileValue.getProfileValueId() != null) {
                int count = this.profileValueMapper.updateByPrimaryKeySelective(profileValue);
                this.checkOvn(count, profileValue);
            }
            if (10L != profileValue.getLevelId()) continue;
            this.messagePublisher.publish("profile", new GlobalProfile(profile.getProfileName(), profileValue.getProfileValue()));
        }
    }

    static {
        GLOBAL.setLevelId(10L);
        GLOBAL.setLevelName("GLOBAL");
        GLOBAL.setLevelValue("GLOBAL");
    }
}

