/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.cache.impl.LovCache;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.LovItem;
import com.hand.hap.system.mapper.LovItemMapper;
import com.hand.hap.system.mapper.LovMapper;
import com.hand.hap.system.service.IKendoLovService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KendoLovServiceImpl
implements IKendoLovService {
    private final Logger logger = LoggerFactory.getLogger(KendoLovServiceImpl.class);
    @Autowired
    private LovMapper lovMapper;
    @Autowired
    private LovItemMapper lovItemMapper;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private LovCache lovCache;

    @Override
    public String getLov(String contextPath, Locale locale, String lovCode) {
        LovEditor editor = this.getLovEditor(contextPath, locale, lovCode);
        try {
            return this.objectMapper.writeValueAsString((Object)editor);
        }
        catch (JsonProcessingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return "''";
        }
    }

    private LovEditor getLovEditor(String contextPath, Locale locale, String lovCode) {
        Lov lov = this.lovCache.getValue(lovCode);
        if (lov == null && (lov = this.lovMapper.selectByCode(lovCode)) != null) {
            List<LovItem> items = this.lovItemMapper.selectByLovId(lov.getLovId());
            lov.setLovItems(items);
            this.lovCache.setValue(lov.getCode(), lov);
        }
        return lov != null ? this.createLovEditor(contextPath, locale, lov, lov.getLovItems()) : null;
    }

    private LovEditor createLovEditor(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
        LovEditor editor = new LovEditor(lov, locale);
        editor.setGrid(new LovGrid(contextPath, locale, lov, items));
        this.buildConditionForm(editor, items, contextPath, locale);
        return editor;
    }

    private void buildConditionForm(LovEditor editor, List<LovItem> items, String contextPath, Locale locale) {
        StringBuilder html = new StringBuilder();
        int customCols = editor.getQueryColumns() == null ? 1 : editor.getQueryColumns();
        int colsNum = 0;
        int labelWidth = 3;
        if (customCols < 1) {
            customCols = 1;
        } else if (customCols > 4) {
            customCols = 4;
        }
        ArrayList<LovItem> formItems = new ArrayList<LovItem>();
        if (items != null) {
            for (LovItem item : items) {
                if (!"Y".equalsIgnoreCase(item.getConditionField())) continue;
                formItems.add(item);
                ++colsNum;
            }
        }
        formItems.sort((a, b) -> a.getConditionFieldSequence() - b.getConditionFieldSequence());
        if (customCols > colsNum && colsNum > 0) {
            customCols = colsNum;
        }
        if (customCols >= 3) {
            labelWidth = 2;
        }
        int colCounter = customCols;
        html.append("<div class='form-group' style='width:100%'>");
        if (formItems != null) {
            int overlength = 12;
            for (LovItem item : formItems) {
                int finalLabelWidth = labelWidth;
                int widthValue = (12 - finalLabelWidth * customCols) / customCols;
                if (!"Y".equalsIgnoreCase(item.getConditionField())) continue;
                String field = StringUtils.defaultIfEmpty((String)item.getConditionFieldName(), (String)item.getGridFieldName());
                if (item.getConditionFieldLabelWidth() != null && item.getConditionFieldLabelWidth() > 0) {
                    finalLabelWidth = item.getConditionFieldLabelWidth();
                }
                if (item.getConditionFieldWidth() != null) {
                    if (item.getConditionFieldWidth() <= 12 - finalLabelWidth && item.getConditionFieldWidth() > 0) {
                        widthValue = item.getConditionFieldWidth();
                    } else if (item.getConditionFieldWidth() > 12 - finalLabelWidth) {
                        widthValue = 12 - finalLabelWidth;
                    }
                }
                if (colCounter > 0) {
                    if (overlength - finalLabelWidth >= widthValue) {
                        overlength = overlength - finalLabelWidth - widthValue;
                        item.setConditionFieldNewline("N");
                        --colCounter;
                    } else {
                        overlength = 12 - finalLabelWidth - widthValue;
                        item.setConditionFieldNewline("Y");
                        colCounter = customCols - 1;
                    }
                } else {
                    item.setConditionFieldNewline("Y");
                    colCounter = customCols - 1;
                }
                if (item.getConditionFieldNewline() == "Y") {
                    html.append("</div><div class='form-group' style='width:100%'>");
                }
                html.append("<label class='col-sm-" + finalLabelWidth + " control-label' >").append(this.messageSource.getMessage(item.getDisplay(), null, item.getDisplay(), locale)).append("</label>").append("<div class='col-sm-" + widthValue + " k-lov-input' >").append("<input name='" + field + "' data-bind='value:data." + field + "' style='width:100%'>").append("</div>");
                editor.getFormItemMap().put(field, this.buildConditionFormItem(item, contextPath));
            }
        }
        html.append("</div>");
        editor.setForm(html.toString());
    }

    private LovFormItem buildConditionFormItem(LovItem item, String contextPath) {
        String type;
        LovFormItem formItem = new LovFormItem();
        switch (type = StringUtils.defaultIfEmpty((String)item.getConditionFieldType(), (String)"text")) {
            case "text": {
                formItem.setType("kendoMaskedTextBox");
                break;
            }
            case "select": {
                formItem.setType("kendoComboBox");
                formItem.setValuePrimitive(true);
                if (StringUtils.isNotEmpty((String)item.getConditionFieldSelectCode())) {
                    formItem.setDataSource(contextPath + "/common/code/" + item.getConditionFieldSelectCode() + "/");
                    formItem.setDataValueField("value");
                    formItem.setDataTextField("meaning");
                    break;
                }
                if (!StringUtils.isNotEmpty((String)item.getConditionFieldSelectUrl())) break;
                formItem.setDataSource(contextPath + item.getConditionFieldSelectUrl());
                formItem.setDataValueField(item.getConditionFieldSelectVf());
                formItem.setDataTextField(item.getConditionFieldSelectTf());
                break;
            }
            case "int": {
                formItem.setType("kendoNumericTextBox");
                break;
            }
            case "date": {
                formItem.setType("kendoDatePicker");
                break;
            }
        }
        return formItem;
    }

    private class LovGridColumn {
        @JsonIgnore
        private Integer sequence = 1;
        private String field;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer width;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Map<String, Object> attributes;

        LovGridColumn(String contextPath, Locale locale, LovItem item) {
            String display = KendoLovServiceImpl.this.messageSource.getMessage(item.getDisplay(), null, item.getDisplay(), locale);
            this.setTitle(display);
            this.setField(item.getGridFieldName());
            this.setAlign(item.getGridFieldAlign());
            this.setSequence(item.getGridFieldSequence());
            this.setWidth(item.getGridFieldWidth());
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public void setAlign(String align) {
            Map<String, Object> attributes = this.getAttributes();
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
                this.setAttributes(attributes);
            }
            attributes.put("style", "text-align:" + align);
        }

        public Integer getSequence() {
            return this.sequence;
        }

        public void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }
    }

    private class LovGrid {
        private Integer height;
        private String url;
        private List<LovGridColumn> columns = new ArrayList<LovGridColumn>();
        private String pageSize;

        LovGrid(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
            String customUrl = lov.getCustomUrl();
            if (StringUtils.isEmpty((String)customUrl)) {
                this.setUrl(contextPath + "/common/lov/" + lov.getCode());
            } else {
                this.setUrl(contextPath + customUrl);
            }
            this.setPageSize(lov.getLovPageSize());
            this.setHeight(lov.getHeight());
            if (items != null) {
                for (LovItem item : items) {
                    if (!"Y".equalsIgnoreCase(item.getGridField())) continue;
                    this.addColumn(new LovGridColumn(contextPath, locale, item));
                }
                this.columns.sort((a, b) -> a.getSequence() - b.getSequence());
            }
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void addColumn(LovGridColumn column) {
            this.columns.add(column);
        }

        public List<LovGridColumn> getColumns() {
            return this.columns;
        }

        public void setColumns(List<LovGridColumn> columns) {
            this.columns = columns;
        }
    }

    private class LovFormItem {
        private String type;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String dataSource;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String dataValueField;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String dataTextField;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean valuePrimitive;

        private LovFormItem() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public String getDataValueField() {
            return this.dataValueField;
        }

        public void setDataValueField(String dataValueField) {
            this.dataValueField = dataValueField;
        }

        public Boolean getValuePrimitive() {
            return this.valuePrimitive;
        }

        public void setValuePrimitive(Boolean valuePrimitive) {
            this.valuePrimitive = valuePrimitive;
        }

        public String getDataTextField() {
            return this.dataTextField;
        }

        public void setDataTextField(String dataTextField) {
            this.dataTextField = dataTextField;
        }
    }

    private class LovEditor {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer queryColumns;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer height;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer width;
        private boolean readonly;
        private String dataValueField;
        private String dataTextField;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String placeholder;
        private String form;
        private Map<String, LovFormItem> formItemMap = new HashMap<String, LovFormItem>();
        private LovGrid grid;
        private Boolean isTree;
        private String idField;
        private String parentIdField;

        LovEditor(Lov lov, Locale locale) {
            if (lov != null) {
                this.setTitle(KendoLovServiceImpl.this.messageSource.getMessage(lov.getTitle(), null, lov.getTitle(), locale));
                this.setWidth(lov.getWidth());
                this.setHeight(lov.getHeight());
                this.setQueryColumns(lov.getQueryColumns());
                this.setDataTextField(lov.getTextField());
                this.setDataValueField(lov.getValueField());
                if (lov.getPlaceholder() != null) {
                    this.setPlaceholder(KendoLovServiceImpl.this.messageSource.getMessage(lov.getPlaceholder(), null, locale));
                }
                if ("Y".equals(lov.getEditableFlag())) {
                    this.setReadonly(false);
                } else {
                    this.setReadonly(true);
                }
                if ("Y".equals(lov.getTreeFlag())) {
                    this.setTree(true);
                    this.setIdField(lov.getIdField());
                    this.setParentIdField(lov.getParentIdField());
                } else {
                    this.setTree(false);
                }
            }
        }

        public Boolean getTree() {
            return this.isTree;
        }

        public void setTree(Boolean tree) {
            this.isTree = tree;
        }

        public String getIdField() {
            return this.idField;
        }

        public void setIdField(String idField) {
            this.idField = idField;
        }

        public String getParentIdField() {
            return this.parentIdField;
        }

        public void setParentIdField(String parentIdField) {
            this.parentIdField = parentIdField;
        }

        public Integer getQueryColumns() {
            return this.queryColumns;
        }

        public void setQueryColumns(Integer queryColumns) {
            this.queryColumns = queryColumns;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public Map<String, LovFormItem> getFormItemMap() {
            return this.formItemMap;
        }

        public void setFormItemMap(Map<String, LovFormItem> formItemMap) {
            this.formItemMap = formItemMap;
        }

        public String getForm() {
            return this.form;
        }

        public void setForm(String form) {
            this.form = form;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public String getDataValueField() {
            return this.dataValueField;
        }

        public void setDataValueField(String dataValueField) {
            this.dataValueField = dataValueField;
        }

        public String getDataTextField() {
            return this.dataTextField;
        }

        public void setDataTextField(String dataTextField) {
            this.dataTextField = dataTextField;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public LovGrid getGrid() {
            return this.grid;
        }

        public void setGrid(LovGrid grid) {
            this.grid = grid;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }
    }
}

