/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.DocSequence;
import com.hand.hap.system.mapper.DocSequenceMapper;
import com.hand.hap.system.service.IDocSequenceService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DocSequenceServiceImpl
implements IDocSequenceService {
    @Autowired
    private DocSequenceMapper docSequenceMapper;

    @Override
    public DocSequence lockDocSequence(IRequest iRequest, DocSequence docSequence) {
        DocSequence resultDocSequence = this.docSequenceMapper.lockDocSequence(docSequence);
        return resultDocSequence;
    }

    @Override
    public DocSequence insertDocSequence(IRequest iRequest, DocSequence docSequence) {
        this.docSequenceMapper.insert(docSequence);
        return docSequence;
    }

    @Override
    public DocSequence updateDocSequence(IRequest iRequest, DocSequence docSequence) {
        this.docSequenceMapper.update(docSequence);
        return docSequence;
    }

    @Override
    public DocSequence processDocSequence(IRequest iRequest, DocSequence docSequence, Long initValue) {
        DocSequence resultDocSequence = ((IDocSequenceService)this.self()).lockDocSequence(iRequest, docSequence);
        if (resultDocSequence != null && resultDocSequence.getNextSeqNumber() != null) {
            resultDocSequence.setNextSeqNumber(resultDocSequence.getNextSeqNumber() + 1L);
            ((IDocSequenceService)this.self()).updateDocSequence(iRequest, resultDocSequence);
        } else {
            resultDocSequence = docSequence;
            resultDocSequence.setNextSeqNumber(initValue);
            ((IDocSequenceService)this.self()).insertDocSequence(iRequest, resultDocSequence);
        }
        return resultDocSequence;
    }

    @Override
    public String getSequence(IRequest iRequest, DocSequence docSequence, String docPrefix, int seqLength, Long initValue) {
        docSequence = ((IDocSequenceService)this.self()).processDocSequence(iRequest, docSequence, initValue);
        String seqNumber = docSequence.getNextSeqNumber().toString();
        String sequence = seqLength <= 0 || seqNumber.length() > seqLength ? docPrefix + seqNumber : docPrefix + StringUtils.leftPad((String)seqNumber, (int)seqLength, (char)'0');
        return sequence;
    }
}

