/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.DashBoard;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.dto.UserDashboard;
import com.hand.hap.system.service.IDashBoardService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DashBoardController
extends BaseController {
    @Autowired
    private IDashBoardService dashBoardService;

    @RequestMapping(value={"/home.html"})
    public ModelAndView home(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        ModelAndView view = new ModelAndView(this.getViewPath() + "/home");
        UserDashboard userDashboard = new UserDashboard();
        userDashboard.setEnabledFlag("Y");
        List<UserDashboard> dashboards = this.dashBoardService.selectMyDashboardConfig(requestContext, userDashboard);
        view.addObject("dashboards", dashboards);
        return view;
    }

    @RequestMapping(value={"/dashboard.html"})
    public ModelAndView dashboard(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        ModelAndView view = new ModelAndView(this.getViewPath() + "/dashboard");
        List<UserDashboard> dashboards = this.dashBoardService.selectMyDashboardConfig(requestContext, new UserDashboard());
        view.addObject("dashboards", dashboards);
        return view;
    }

    @RequestMapping(value={"/dashboard/add"})
    @ResponseBody
    public ResponseData addMyDashboard(HttpServletRequest request, @RequestBody List<UserDashboard> userDashboards) {
        IRequest requestContext = this.createRequestContext(request);
        for (UserDashboard userDashboard : userDashboards) {
            userDashboard.setUserId(requestContext.getUserId());
            this.dashBoardService.insertMyDashboard(this.createRequestContext(request), userDashboard);
        }
        return new ResponseData(this.dashBoardService.selectMyDashboardConfig(requestContext, new UserDashboard()));
    }

    @RequestMapping(value={"/dashboard/update"})
    @ResponseBody
    public ResponseData updateMyDashboardConfig(HttpServletRequest request, @RequestBody List<UserDashboard> userDashboards) {
        this.dashBoardService.updateMyDashboardConfig(this.createRequestContext(request), userDashboards);
        return new ResponseData();
    }

    @RequestMapping(value={"/dashboard/remove"})
    @ResponseBody
    public ResponseData removeDashboard(HttpServletRequest request, @RequestBody List<UserDashboard> userDashboards) {
        IRequest requestContext = this.createRequestContext(request);
        for (UserDashboard userDashboard : userDashboards) {
            this.dashBoardService.removeDashboard(requestContext, userDashboard);
        }
        return new ResponseData(this.dashBoardService.selectMyDashboardConfig(requestContext, new UserDashboard()));
    }

    @RequestMapping(value={"/sys/dashboard/query", "/api/sys/dashboard/query"})
    @ResponseBody
    public ResponseData query(DashBoard dashBoard, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.dashBoardService.selectDashBoard(requestContext, dashBoard, page, pagesize));
    }

    @RequestMapping(value={"/dashboard/query"})
    @ResponseBody
    public ResponseData queryMyDashBoard(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.dashBoardService.selectMyDashboardConfig(requestContext, new UserDashboard()));
    }

    @RequestMapping(value={"/sys/dashboard/remove", "/api/sys/dashboard/remove"})
    @ResponseBody
    public ResponseData remove(@RequestBody List<DashBoard> dashBoards, BindingResult result, HttpServletRequest request) {
        this.dashBoardService.batchDelete(dashBoards);
        return new ResponseData();
    }

    @RequestMapping(value={"/sys/dashboard/submit", "/api/sys/dashboard/submit"})
    @ResponseBody
    public ResponseData submit(@RequestBody List<DashBoard> dashBoards, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dashBoards, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.dashBoardService.batchUpdate(requestContext, dashBoards));
    }
}

