/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.hap.account.dto.Role;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.RoleException;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.adaptor.ILoginAdaptor;
import com.hand.hap.adaptor.impl.DefaultLoginAdaptor;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.core.exception.IBaseException;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

@Controller
public class LoginController
extends BaseController
implements InitializingBean {
    @Autowired(required=false)
    private ILoginAdaptor loginAdaptor;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IUserService userService;

    @RequestMapping(value={"/login.html", "/login"})
    @Timed
    public ModelAndView loginView(HttpServletRequest request, HttpServletResponse response) {
        return this.getLoginAdaptor().loginView(request, response);
    }

    @GetMapping(value={"/role.html", "/role"})
    public ModelAndView roleView(HttpServletRequest request, HttpServletResponse response) throws BaseException {
        return this.getLoginAdaptor().roleView(request, response);
    }

    @GetMapping(value={"/", "/index.html"})
    public ModelAndView indexView(HttpServletRequest request, HttpServletResponse response) {
        return this.getLoginAdaptor().indexView(request, response);
    }

    @PostMapping(value={"/role"})
    public ModelAndView selectRole(Role role, HttpServletRequest request, HttpServletResponse response) throws RoleException {
        return this.getLoginAdaptor().doSelectRole(role, request, response);
    }

    @RequestMapping(value={"/sys/role/change"})
    public ModelAndView changeRole(HttpServletRequest request, HttpServletResponse response, Long roleId) throws RoleException {
        Role role = new Role();
        role.setRoleId(roleId);
        return this.getLoginAdaptor().doSelectRole(role, request, response);
    }

    @PostMapping(value={"/sessionExpiredLogin"})
    public ResponseData sessionExpiredLogin(User account, HttpServletRequest request, HttpServletResponse response) throws BaseException {
        return this.getLoginAdaptor().sessionExpiredLogin(account, request, response);
    }

    @GetMapping(value={"/password/reset"})
    public ModelAndView resetPassword(HttpServletRequest request) {
        ModelAndView view = new ModelAndView("update_password");
        HttpSession session = request.getSession(false);
        if (session != null) {
            String reason = (String)session.getAttribute("PASSWORD_UPDATE_REASON");
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            view.addObject("update_password_title", (Object)this.updatePasswordTitle(reason, locale));
        }
        return view;
    }

    @PostMapping(value={"/password/reset"})
    public ModelAndView resetPassword(HttpServletRequest request, String newPwd, String newPwdAgain) throws UserException {
        ModelAndView view = new ModelAndView("update_password");
        IRequest iRequest = this.createRequestContext(request);
        HttpSession session = request.getSession(false);
        String reason = (String)session.getAttribute("PASSWORD_UPDATE_REASON");
        try {
            if (reason != null) {
                request.getSession(false).removeAttribute("PASSWORD_UPDATE_REASON");
                this.userService.firstAndExpiredLoginUpdatePassword(iRequest, newPwd, newPwdAgain);
                return new ModelAndView("redirect:/");
            }
        }
        catch (Exception e) {
            if (e instanceof IBaseException) {
                IBaseException be = (IBaseException)((Object)e);
                Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
                String messageKey = be.getDescriptionKey();
                String message = this.getMessageSource().getMessage(messageKey, be.getParameters(), messageKey, locale);
                view.addObject("update_password_title", (Object)this.updatePasswordTitle(reason, locale));
                view.addObject("message", (Object)message);
            }
            throw e;
        }
        return view;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.loginAdaptor == null) {
            this.loginAdaptor = new DefaultLoginAdaptor();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this.loginAdaptor);
        }
    }

    @GetMapping(value={"/casLoginFailure"})
    public ModelAndView casLoginError(HttpServletRequest request, HttpServletResponse response) throws UserException {
        return this.getLoginAdaptor().casLoginFailure(request, response);
    }

    private ILoginAdaptor getLoginAdaptor() {
        return this.loginAdaptor;
    }

    private String updatePasswordTitle(String reason, Locale locale) {
        String reasonTitle = "";
        switch (reason) {
            case "EXPIRED": {
                reasonTitle = this.getMessageSource().getMessage("error.user.update_password", null, locale);
                break;
            }
            case "RESET": {
                reasonTitle = this.getMessageSource().getMessage("sys.config.resetpassword", null, locale);
                break;
            }
        }
        return reasonTitle;
    }
}

