/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.security.permission.dto.DataPermissionTableRule;
import com.hand.hap.security.permission.service.IDataPermissionTableRuleService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPermissionTableRuleServiceImpl
extends BaseServiceImpl<DataPermissionTableRule>
implements IDataPermissionTableRuleService {
    @Autowired
    IMessagePublisher iMessagePublisher;

    @Override
    public void removeRule(List<DataPermissionTableRule> list) {
        this.batchDelete(list);
        this.updateCache(list, "dataPermission.tableRuleRemove");
    }

    @Override
    public List<DataPermissionTableRule> updateRule(IRequest request, List<DataPermissionTableRule> list) {
        List<DataPermissionTableRule> dto = this.batchUpdate(request, list);
        this.updateCache(list, "dataPermission.tableRuleUpdate");
        return dto;
    }

    private void updateCache(List<DataPermissionTableRule> list, String channel) {
        list.forEach(v -> this.iMessagePublisher.publish(channel, v));
    }
}

