/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.function.dto.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ResourceAccessor {
    public static final ThreadLocal<Resource> CURRENT_RESOURCE = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(ResourceAccessor.class);
    private static String APP_SERVLET_CONTEXT_KEY = FrameworkServlet.SERVLET_CONTEXT_PREFIX + "appServlet";
    @Autowired
    private CacheManager cacheManager;
    private Cache<Resource> resourceCache;
    private RequestMappingHandlerMapping requestMappingHandlerMapping;

    private void initRequestMappingHandlerMapping(HttpServletRequest request) {
        if (this.requestMappingHandlerMapping != null) {
            return;
        }
        try {
            ServletContext servletContext = request.getServletContext();
            WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext, (String)APP_SERVLET_CONTEXT_KEY);
            Map allRequestMappings = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)appContext, HandlerMapping.class, (boolean)true, (boolean)false);
            for (HandlerMapping handlerMapping : allRequestMappings.values()) {
                if (!(handlerMapping instanceof RequestMappingHandlerMapping)) continue;
                this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)handlerMapping;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Resource getResourceOfUri(HttpServletRequest request, String uriOri, String uriTrim) {
        Resource resource;
        if (this.resourceCache == null) {
            this.resourceCache = this.cacheManager.getCache("resource_url");
        }
        if ((resource = this.resourceCache.getValue(uriTrim)) == null) {
            if (logger.isWarnEnabled()) {
                logger.debug("url {} is not registered", (Object)uriTrim);
            }
            if (!StringUtils.endsWith((String)uriOri, (String)".html")) {
                String pattern = this.getBestMatchPattern(request, uriOri);
                if (Objects.equals(pattern, uriOri)) {
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{} match pattern {}", (Object)uriOri, (Object)pattern);
                }
                if (pattern.startsWith("/")) {
                    pattern = pattern.substring(1);
                }
                if ((resource = this.resourceCache.getValue(pattern)) == null && logger.isWarnEnabled()) {
                    logger.debug("pattern {} is not registered", (Object)pattern);
                }
            }
        }
        return resource;
    }

    private String getBestMatchPattern(HttpServletRequest request, String uri) {
        this.initRequestMappingHandlerMapping(request);
        if (this.requestMappingHandlerMapping != null) {
            Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
            for (Map.Entry entry : handlerMethods.entrySet()) {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                List patterns = requestMappingInfo.getPatternsCondition().getMatchingPatterns(uri);
                if (patterns.size() <= 0) continue;
                return (String)patterns.get(0);
            }
        }
        return uri;
    }
}

