/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.message.components.DefaultRoleResourceListener;
import com.hand.hap.security.ResourceAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.web.FilterInvocation;

public class PermissionVoter
implements AccessDecisionVoter<FilterInvocation> {
    private static final Logger logger = LoggerFactory.getLogger(PermissionVoter.class);
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    private DefaultRoleResourceListener roleResourceListener;

    public boolean supports(ConfigAttribute attribute) {
        return false;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, FilterInvocation fi, Collection<ConfigAttribute> attributes) {
        Long[] roleIds;
        HttpSession session;
        int result = 0;
        assert (authentication != null);
        assert (fi != null);
        assert (attributes != null);
        for (ConfigAttribute attribute : attributes) {
            if (!"permitAll".equals(attribute.toString())) continue;
            return result;
        }
        HttpServletRequest request = fi.getRequest();
        String uri = StringUtils.substringAfter((String)request.getRequestURI(), (String)request.getContextPath());
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ("".equals(uri)) {
            return 0;
        }
        Resource resource = ResourceAccessor.CURRENT_RESOURCE.get();
        ResourceAccessor.CURRENT_RESOURCE.remove();
        if (resource == null) {
            return 0;
        }
        if (!"Y".equalsIgnoreCase(resource.getAccessCheck())) {
            if (logger.isDebugEnabled()) {
                logger.debug("url :'{}' need no access control.", (Object)uri);
            }
            return 0;
        }
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            Set authrotities = AuthorityUtils.authorityListToSet((Collection)oAuth2Authentication.getAuthorities());
            IRole role = null;
            for (String roleCode : authrotities) {
                List<Long> ids;
                role = this.roleService.selectRoleByCode(roleCode);
                if (role == null || (ids = this.roleResourceListener.getRoleResource(role.getRoleId())) == null || !ids.contains(resource.getResourceId())) continue;
                return 0;
            }
        }
        if ((session = request.getSession(false)) == null) {
            return -1;
        }
        Long roleId = null;
        roleId = (Long)session.getAttribute("roleId");
        if (roleId == null) {
            return -1;
        }
        for (Long rid : roleIds = RequestHelper.createServiceRequest(request).getAllRoleId()) {
            List<Long> ids = this.roleResourceListener.getRoleResource(rid);
            if (ids == null || !ids.contains(resource.getResourceId())) continue;
            return 0;
        }
        logger.debug("access to uri :'{}' denied.", (Object)uri);
        result = -1;
        return result;
    }
}

