/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class CsrfSecurityRequestMatcher
implements RequestMatcher {
    private Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private PathMatcher matcher = new AntPathMatcher();
    private List<String> excludeUrls;

    public List<String> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<String> excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public boolean matches(HttpServletRequest httpServletRequest) {
        boolean isPostMethod;
        boolean isFilter = true;
        boolean bl = isPostMethod = !this.allowedMethods.matcher(httpServletRequest.getMethod()).matches();
        if (isPostMethod) {
            if (this.excludeUrls != null && this.excludeUrls.size() > 0) {
                String servletPath = httpServletRequest.getServletPath();
                for (String url : this.excludeUrls) {
                    if (!this.matcher.match(url, servletPath)) continue;
                    isFilter = false;
                }
            }
        } else {
            isFilter = false;
        }
        return isFilter;
    }
}

