/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.impl;

import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.IQueueMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.data.redis.serializer.RedisSerializer;

public class QueueMessageListener<T>
implements IQueueMessageListener<T>,
BeanNameAware {
    private String queue;
    private RedisSerializer<T> redisSerializer;
    private IMessageConsumer<T>[] consumers = new IMessageConsumer[0];
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    public void setRedisSerializer(RedisSerializer<T> redisSerializer) {
        this.redisSerializer = redisSerializer;
    }

    @Override
    public RedisSerializer<T> getRedisSerializer() {
        return this.redisSerializer;
    }

    public IMessageConsumer<T>[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IMessageConsumer<T>[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public void onQueueMessage(T message, String queue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("receive message: {}, from: {}, consumers: {}", new Object[]{message, this.queue, this.consumers.length});
        }
        for (IMessageConsumer<T> c : this.consumers) {
            try {
                c.onMessage(message, queue);
            }
            catch (Throwable throwable) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.error("exception occurred while consumer " + c + " handle message:" + message, throwable);
            }
        }
    }

    public void setBeanName(String name) {
        if (this.queue == null) {
            this.setQueue(name);
        }
    }
}

